/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RetryJobCommand
implements Command<Boolean> {
    private static final long serialVersionUID = 3748547428936058760L;
    private final int retries;
    private final JobData jobData;

    public RetryJobCommand(int retries, JobData jobData) {
        this.retries = retries;
        this.jobData = jobData;
    }

    @Override
    public Boolean execute(Environment environment) {
        JobImpl<?> job = EnvTool.getRepository().getJob(this.jobData.getJobId());
        if (job == null) {
            return Boolean.FALSE;
        }
        job.setRetries(this.retries);
        JobExecutor jobExecutor = environment.get(JobExecutor.class);
        if (jobExecutor != null) {
            Transaction transaction = environment.get(Transaction.class);
            if (transaction == null) {
                throw new PvmException("no transaction in environment");
            }
            JobAddedNotification jobNotificator = new JobAddedNotification(jobExecutor);
            transaction.registerSynchronization(jobNotificator);
        }
        return Boolean.TRUE;
    }
}

