/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.util.MimeTypes;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class ServletContextImpl
implements ExtServletContext {
    private final Bundle bundle;
    private final ServletContext context;
    private final HttpContext httpContext;
    private final Map<String, Object> attributes;

    public ServletContextImpl(Bundle bundle, ServletContext context, HttpContext httpContext) {
        this.bundle = bundle;
        this.context = context;
        this.httpContext = httpContext;
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    public Set getResourcePaths(String path) {
        Enumeration paths = this.bundle.getEntryPaths(this.normalizePath(path));
        if (paths == null || !paths.hasMoreElements()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        while (paths.hasMoreElements()) {
            set.add((String)paths.nextElement());
        }
        return set;
    }

    public URL getResource(String path) {
        return this.httpContext.getResource(this.normalizePath(path));
    }

    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = path.trim().replaceAll("/+", "/");
        if (normalizedPath.startsWith("/") && normalizedPath.length() > 1) {
            normalizedPath = normalizedPath.substring(1);
        }
        return normalizedPath;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Servlet getServlet(String name) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return Collections.enumeration(Collections.emptyList());
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    public void log(String message) {
        SystemLogger.info(message);
    }

    public void log(Exception cause, String message) {
        SystemLogger.error(message, cause);
    }

    public void log(String message, Throwable cause) {
        SystemLogger.error(message, cause);
    }

    public String getServletContextName() {
        return this.context.getServletContextName();
    }

    public String getRealPath(String name) {
        return null;
    }

    public String getServerInfo() {
        return this.context.getServerInfo();
    }

    public String getMimeType(String file) {
        String type = this.httpContext.getMimeType(file);
        if (type != null) {
            return type;
        }
        return MimeTypes.get().getByFile(file);
    }

    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.httpContext.handleSecurity(req, res);
    }
}

