/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

final class ServletHandlerRequest
extends HttpServletRequestWrapper {
    private final String alias;
    private String pathInfo;
    private boolean pathInfoCalculated = false;

    public ServletHandlerRequest(HttpServletRequest req, String alias) {
        super(req);
        this.alias = alias;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return super.getAuthType();
    }

    public String getPathInfo() {
        if (!this.pathInfoCalculated) {
            this.pathInfo = this.calculatePathInfo();
            this.pathInfoCalculated = true;
        }
        return this.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public String getServletPath() {
        if ("/".equals(this.alias)) {
            return "";
        }
        return this.alias;
    }

    private String calculatePathInfo() {
        int servletPathLength = this.getServletPath().length();
        String contextPath = this.getContextPath();
        String pathInfo = this.getRequestURI();
        pathInfo = pathInfo.substring(contextPath.length());
        pathInfo = pathInfo.replaceAll("[/]{2,}", "/");
        int scPos = (pathInfo = pathInfo.substring(servletPathLength)).indexOf(59);
        if (scPos > 0) {
            pathInfo = pathInfo.substring(0, scPos);
        }
        if ("".equals(pathInfo) && servletPathLength != 0) {
            pathInfo = null;
        }
        if (pathInfo != null && !pathInfo.startsWith("/")) {
            pathInfo = "/" + pathInfo;
        }
        return pathInfo;
    }
}

