/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import java.io.IOException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.writer.CacheWriterManager;

public class SyncAwareStore
implements Store {
    private final Store store;
    private final CacheLockProvider cacheLockProvider;

    public SyncAwareStore(Store store) {
        this.store = store;
        this.cacheLockProvider = new StripedReadWriteLockSync(2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return true;
        }
        Object key = element.getObjectKey();
        Object value = element.getObjectValue();
        Sync sync = this.cacheLockProvider.getSyncForKey(key);
        this.cacheLockProvider.getSyncForKey(key).lock(LockType.WRITE);
        try {
            boolean bl = this.store.put(element);
            return bl;
        }
        finally {
            this.cacheLockProvider.getSyncForKey(key).lock(LockType.WRITE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element remove(Object key) {
        Sync sync = this.cacheLockProvider.getSyncForKey(key);
        this.cacheLockProvider.getSyncForKey(key).lock(LockType.WRITE);
        try {
            Element element = this.store.remove(key);
            return element;
        }
        finally {
            this.cacheLockProvider.getSyncForKey(key).lock(LockType.WRITE);
        }
    }

    public boolean bufferFull() {
        return this.store.bufferFull();
    }

    public boolean containsKey(Object key) {
        return this.store.containsKey(key);
    }

    public void dispose() {
        this.store.dispose();
    }

    public void expireElements() {
        this.store.expireElements();
    }

    public void flush() throws IOException {
        this.store.flush();
    }

    public Element get(Object key) {
        return this.store.get(key);
    }

    public Policy getEvictionPolicy() {
        return this.store.getEvictionPolicy();
    }

    public Object getInternalContext() {
        return this.cacheLockProvider;
    }

    public Object[] getKeyArray() {
        return this.store.getKeyArray();
    }

    public Element getQuiet(Object key) {
        return this.store.getQuiet(key);
    }

    public int getSize() {
        return this.store.getSize();
    }

    public long getSizeInBytes() {
        return this.getSizeInBytes();
    }

    public Status getStatus() {
        return this.store.getStatus();
    }

    public int getTerracottaClusteredSize() {
        return this.store.getTerracottaClusteredSize();
    }

    public boolean isCacheCoherent() {
        return this.store.isCacheCoherent();
    }

    public boolean isClusterCoherent() {
        return this.store.isClusterCoherent();
    }

    public boolean isNodeCoherent() {
        return this.store.isNodeCoherent();
    }

    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.store.putWithWriter(element, writerManager);
    }

    public void removeAll() throws CacheException {
        this.store.removeAll();
    }

    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.removeWithWriter(key, writerManager);
    }

    public void setEvictionPolicy(Policy policy) {
        this.store.setEvictionPolicy(policy);
    }

    public void setNodeCoherent(boolean coherent) throws UnsupportedOperationException {
        this.store.setNodeCoherent(coherent);
    }

    public void waitUntilClusterCoherent() throws UnsupportedOperationException {
        this.store.waitUntilClusterCoherent();
    }
}

