/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.Flow;
import org.ow2.orchestra.definition.activity.IAbstractBpelActivity;
import org.ow2.orchestra.definition.activity.IScope;
import org.ow2.orchestra.definition.activity.Pick;
import org.ow2.orchestra.definition.activity.Receive;
import org.ow2.orchestra.definition.activity.Sequence;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.Target;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.wsdl.WsdlsInfos;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelProcess
extends ProcessDefinitionImpl {
    private static final long serialVersionUID = 1L;
    protected String queryLanguage;
    protected String expressionLanguage;
    protected boolean suppressJoinFailure = false;
    protected boolean exitOnStandardFault = false;
    protected String targetNamespace = null;
    protected ProcessDefinitionUUID processUUID;
    protected boolean isRetired = false;
    protected WsdlsInfos wsdlInfos;
    protected ProcessResourcesRepository resourcesRepository;
    protected int numberOfStartElements = 0;
    protected List<InboundMessageElement> inboundMessageElements = new ArrayList<InboundMessageElement>();
    protected Collection<CorrelationSet> commonCorrelationSets = null;
    protected InstanceCreationLock instanceCreationLock;

    public BpelProcess(String name, String targetNamespace, long version) {
        this.name = name;
        this.targetNamespace = targetNamespace;
        this.processUUID = IdFactory.getNewProcessUUID(Long.toString(version));
        this.instanceCreationLock = new InstanceCreationLock(this);
    }

    protected BpelProcess() {
    }

    @Override
    protected ExecutionImpl newProcessInstance() {
        BpelExecution instance = new BpelExecution();
        instance.setProcessDefinition(this);
        instance.setProcessInstance(instance);
        EnvTool.getRepository().storeInstance(instance);
        ProcessInstanceUUID processInstanceUUID = IdFactory.getNewInstanceUUID(this.getUUID(), instance.getDbid());
        instance.setProcessInstanceUUID(processInstanceUUID);
        return instance;
    }

    public InboundMessageElement getStartElement(OperationKey operationKey) {
        for (InboundMessageElement inboundMessageElement : this.inboundMessageElements) {
            if (!inboundMessageElement.isCreateInstance()) continue;
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                if (!receivingElement.getOperationKey().equals(operationKey)) continue;
                return inboundMessageElement;
            }
        }
        return null;
    }

    public void addInboundMessageElement(InboundMessageElement receivingElement) {
        this.inboundMessageElements.add(receivingElement);
        if (receivingElement.isCreateInstance()) {
            ++this.numberOfStartElements;
        }
    }

    public List<InboundMessageElement> getInboundMessageElements() {
        return this.inboundMessageElements;
    }

    public List<ReceivingElement> getReceivingElements(OperationKey operationKey) {
        ArrayList<ReceivingElement> result = new ArrayList<ReceivingElement>();
        for (InboundMessageElement inboundMessageElement : this.inboundMessageElements) {
            for (ReceivingElement receivingElement : inboundMessageElement.getReceivingElements()) {
                if (!receivingElement.getOperationKey().equals(operationKey)) continue;
                result.add(receivingElement);
            }
        }
        return result;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public void setQueryLanguage(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    public boolean isSuppressJoinFailure() {
        return this.suppressJoinFailure;
    }

    public void setSuppressJoinFailure(boolean suppressJoinFailure) {
        this.suppressJoinFailure = suppressJoinFailure;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setWsdlInfos(WsdlsInfos wsdlInfos) {
        this.wsdlInfos = wsdlInfos;
    }

    public WsdlsInfos getWsdlInfos() {
        return this.wsdlInfos;
    }

    public QName getQName() {
        return new QName(this.targetNamespace, this.name);
    }

    public ProcessResourcesRepository getResourcesRepository() {
        return this.resourcesRepository;
    }

    public void setResourcesRepository(ProcessResourcesRepository resourcesRepository) {
        this.resourcesRepository = resourcesRepository;
    }

    public void staticAnalysisCheck(Parse parse) {
        if (this.getNumberOfStartElements() == 0) {
            String message = StaticAnalysisFault.getMessage("SA00015", "  Process should have at least one receive or pick with createInstance set to yes");
            parse.addProblem(message, new StaticAnalysisException("SA00015"));
        } else {
            HashSet<InboundMessageElement> startElementFound = new HashSet<InboundMessageElement>();
            this.isFirstActivityCreateInstance(this.getInitial(), parse, startElementFound);
            int nbUnreachable = this.getNumberOfStartElements() - startElementFound.size();
            if (nbUnreachable != 0) {
                String message = StaticAnalysisFault.getMessage("SA00056", nbUnreachable + " activities with \"createInstance='yes'\" are not process start activities.");
                parse.addProblem(message, new StaticAnalysisException("SA00056"));
            } else if (startElementFound.size() > 1) {
                try {
                    this.commonCorrelationSets = this.checkCommonCS();
                }
                catch (StaticAnalysisException e) {
                    parse.addProblem(e.getMessage(), e);
                }
            }
        }
    }

    private void isFirstActivityCreateInstance(NodeImpl node, Parse parse, Set<InboundMessageElement> startElementFound) {
        IAbstractBpelActivity activity = (IAbstractBpelActivity)node.getBehaviour();
        if (activity instanceof Receive) {
            if (((Receive)activity).isCreateInstance()) {
                startElementFound.add((InboundMessageElement)((Object)activity));
                return;
            }
        } else if (activity instanceof Pick && ((Pick)activity).isCreateInstance()) {
            startElementFound.add((InboundMessageElement)((Object)activity));
            return;
        }
        if (!this.hasControlDependencyOnStartActivity(activity)) {
            if (activity instanceof IScope) {
                this.isFirstActivityCreateInstance((NodeImpl)node.getNodes().get(0), parse, startElementFound);
            } else if (activity instanceof Sequence) {
                this.isFirstActivityCreateInstance((NodeImpl)node.getNodes().get(0), parse, startElementFound);
            } else if (activity instanceof Flow) {
                for (Node child : node.getNodes()) {
                    this.isFirstActivityCreateInstance((NodeImpl)child, parse, startElementFound);
                }
            } else {
                String message = StaticAnalysisFault.getMessage("SA00056", "Activity " + node.getName() + " is not a start activity");
                parse.addProblem(message, new StaticAnalysisException("SA00056"));
            }
        }
    }

    private boolean hasControlDependencyOnStartActivity(IAbstractBpelActivity activity) {
        if (activity instanceof InboundMessageElement && ((InboundMessageElement)((Object)activity)).isCreateInstance()) {
            return true;
        }
        if (activity.getTargets() != null) {
            for (Target t : activity.getTargets()) {
                if (!this.hasControlDependencyOnStartActivity(t.getLink().getSourceActivity())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<CorrelationSet> checkCommonCS() {
        HashSet<CorrelationSet> commonCS = null;
        boolean initialized = false;
        for (InboundMessageElement inboundMessageElement : this.inboundMessageElements) {
            if (!inboundMessageElement.isCreateInstance()) continue;
            for (ReceivingElement startElement : inboundMessageElement.getReceivingElements()) {
                List<Correlation> correlations = startElement.getCorrelations();
                if (correlations != null && !correlations.isEmpty()) {
                    if (!initialized) {
                        commonCS = new HashSet<CorrelationSet>();
                        for (Correlation correlation : correlations) {
                            commonCS.add(correlation.getCorrelationSet());
                        }
                    } else {
                        if (commonCS == null) {
                            throw new StaticAnalysisException("SA00057");
                        }
                        HashSet<CorrelationSet> elementCs = new HashSet<CorrelationSet>();
                        for (Correlation correlation : correlations) {
                            elementCs.add(correlation.getCorrelationSet());
                        }
                        commonCS.retainAll(elementCs);
                        if (commonCS.isEmpty()) {
                            throw new StaticAnalysisException("SA00057");
                        }
                    }
                } else if (commonCS != null) {
                    throw new StaticAnalysisException("SA00057");
                }
                initialized = true;
            }
        }
        if (commonCS != null) {
            for (CorrelationSet cs : commonCS) {
                for (InboundMessageElement inboundMessageElement : this.inboundMessageElements) {
                    if (!inboundMessageElement.isCreateInstance()) continue;
                    for (ReceivingElement startElement : inboundMessageElement.getReceivingElements()) {
                        for (Correlation correlation : startElement.getCorrelations()) {
                            if (!correlation.getCorrelationSet().equals(cs) || correlation.getInitiate().equals((Object)Correlation.Initiate.join)) continue;
                            throw new StaticAnalysisException("SA00057");
                        }
                    }
                }
            }
        }
        return commonCS;
    }

    public ProcessDefinitionUUID getUUID() {
        return this.processUUID;
    }

    public ProcessDefinitionData getProcessDefinitionData() {
        return new ProcessDefinitionData(this.getUUID(), this.name, this.targetNamespace, this.version, this.isRetired ? ProcessState.RETIRED : ProcessState.ACTIVE);
    }

    public int getNumberOfStartElements() {
        return this.numberOfStartElements;
    }

    public Collection<CorrelationSet> getCommonCorrelationSets() {
        return this.commonCorrelationSets;
    }

    protected void setCommonCorrelationSets(Set<CorrelationSet> commonCorrelationSets) {
        this.commonCorrelationSets = commonCorrelationSets;
    }

    public void setRetired(boolean retired) {
        if (this.isRetired == retired) {
            return;
        }
        this.isRetired = retired;
        EnvTool.getRecorder().recordProcessStateChanged(this.getProcessDefinitionData());
    }

    public boolean isRetired() {
        return this.isRetired;
    }

    public static class InstanceCreationLock {
        protected long dbid;
        protected ProcessDefinitionUUID processUUID;
        protected QName processQName;

        protected InstanceCreationLock() {
        }

        private InstanceCreationLock(BpelProcess bpelProcess) {
            this.processUUID = bpelProcess.getUUID();
            this.processQName = bpelProcess.getQName();
        }
    }
}

