/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.activity.ActivityWithSingleChild;
import org.ow2.orchestra.definition.activity.ICatchActivity;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.exception.FaultWithElement;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCatchActivity
extends ActivityWithSingleChild {
    private static final long serialVersionUID = 660890927633975015L;

    protected BaseCatchActivity(NodeImpl child, ActivityDefinitionUUID uuid, String name) {
        super(child, uuid, name);
    }

    @Override
    public void signal(BpelExecution execution) {
        ScopeRuntime scopeRuntime = execution.getCurrentScopeRuntime();
        scopeRuntime.setState(ScopeState.COMPLETED_UNSUCCESSFUL, execution);
        scopeRuntime.setLastException(null);
    }

    public static Node findFaultHandler(ScopeRuntime scopeRuntime, List<Node> nodes, BpelFaultException bpelFaultException) {
        if (nodes.size() > 5) {
            Element bfe;
            ICatchActivity cd;
            HashMap<NodeImpl, ICatchActivity> catches = new HashMap<NodeImpl, ICatchActivity>();
            for (int i = 5; i < nodes.size(); ++i) {
                NodeImpl node = (NodeImpl)nodes.get(i);
                ICatchActivity iCatchActivity = (ICatchActivity)node.getBehaviour();
                if (iCatchActivity == null) {
                    Misc.unreachableStatement("The behaviour of a catch node cannot be null");
                }
                catches.put(node, iCatchActivity);
            }
            if (bpelFaultException instanceof FaultWithMessageVariable) {
                MessageVariable bfm = ((FaultWithMessageVariable)bpelFaultException).getFaultMessage();
                if (bfm != null && bfm.getParts() != null && bfm.getParts().size() != 0) {
                    QName type;
                    if (bpelFaultException.getFaultName() != null) {
                        for (Map.Entry<Object, Object> entry : bfm.getParts().entrySet()) {
                            if (entry.getValue() == null) continue;
                            for (Map.Entry catchEntry : catches.entrySet()) {
                                ICatchActivity cd2 = (ICatchActivity)catchEntry.getValue();
                                type = cd2.getFaultMessageType();
                                if (!bpelFaultException.getFaultName().equals(cd2.getFaultName()) || type == null || !type.getNamespaceURI().equals(((Element)entry.getValue()).getNamespaceURI()) || !type.getLocalPart().equals(((Element)entry.getValue()).getLocalName())) continue;
                                return (Node)catchEntry.getKey();
                            }
                        }
                        for (Map.Entry<Object, Object> entry : catches.entrySet()) {
                            cd = (ICatchActivity)entry.getValue();
                            if (!bpelFaultException.getFaultName().equals(cd.getFaultName()) || cd.getFaultVariable() != null) continue;
                            return (Node)entry.getKey();
                        }
                    }
                    for (Map.Entry<Object, Object> entry : bfm.getParts().entrySet()) {
                        if (entry.getValue() == null) continue;
                        for (Map.Entry catchEntry : catches.entrySet()) {
                            ICatchActivity cd2 = (ICatchActivity)catchEntry.getValue();
                            type = cd2.getFaultMessageType();
                            if (cd2.getFaultName() != null || type == null || !type.getNamespaceURI().equals(((Element)entry.getValue()).getNamespaceURI()) || !type.getLocalPart().equals(((Element)entry.getValue()).getLocalName())) continue;
                            return (Node)catchEntry.getKey();
                        }
                    }
                }
            } else if (bpelFaultException instanceof FaultWithElement && (bfe = ((FaultWithElement)bpelFaultException).getFaultElement()) != null) {
                QName type;
                if (bpelFaultException.getFaultName() != null) {
                    for (Map.Entry entry : catches.entrySet()) {
                        cd = (ICatchActivity)entry.getValue();
                        type = cd.getFaultElement();
                        if (!bpelFaultException.getFaultName().equals(cd.getFaultName()) || type == null || !type.getNamespaceURI().equals(bfe.getNamespaceURI()) || !type.getLocalPart().equals(bfe.getLocalName())) continue;
                        return (Node)entry.getKey();
                    }
                    for (Map.Entry<Object, Object> entry : catches.entrySet()) {
                        cd = (ICatchActivity)entry.getValue();
                        if (!bpelFaultException.getFaultName().equals(cd.getFaultName()) || cd.getFaultVariable() != null) continue;
                        return (Node)entry.getKey();
                    }
                }
                for (Map.Entry entry : catches.entrySet()) {
                    cd = (ICatchActivity)entry.getValue();
                    type = cd.getFaultElement();
                    if (cd.getFaultName() != null || type == null || !type.getNamespaceURI().equals(bfe.getNamespaceURI()) || !type.getLocalPart().equals(bfe.getLocalName())) continue;
                    return (Node)entry.getKey();
                }
            }
            if (bpelFaultException.getFaultName() != null) {
                for (Map.Entry catchEntry : catches.entrySet()) {
                    ICatchActivity iCatchActivity = (ICatchActivity)catchEntry.getValue();
                    if (!bpelFaultException.getFaultName().equals(iCatchActivity.getFaultName())) continue;
                    return (Node)catchEntry.getKey();
                }
            }
        }
        return null;
    }
}

