/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.IEventHandlerActivity;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.definition.element.OnAlarm;
import org.ow2.orchestra.definition.element.OnEvent;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.pvm.activity.ActivityExecution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.OpenExecution;
import org.ow2.orchestra.pvm.session.MessageSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.CheckHasMessageJob;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandlerActivity
extends AbstractActivity
implements InboundMessageElement,
IEventHandlerActivity {
    private static final long serialVersionUID = 3582119246610559074L;
    public static final String ON_ALARM_PARAM = "onAlarm";
    protected List<OnEvent> onEvents = new ArrayList<OnEvent>();
    protected List<OnAlarm> onAlarms = new ArrayList<OnAlarm>();

    @Override
    public ActivityType getType() {
        return ActivityType.SCOPE_EVENT_HANDLER;
    }

    @Override
    public List<ReceivingElement> getReceivingElements() {
        return new ArrayList<ReceivingElement>(this.onEvents);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (parameters != null) {
            OnEvent onEvent = (OnEvent)parameters.get("receivingElement");
            NodeImpl onAlarmActivity = (NodeImpl)parameters.get(ON_ALARM_PARAM);
            if (!this.onEvents.isEmpty()) {
                Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(execution));
            }
            if (onEvent != null) {
                MessageVariable message = (MessageVariable)parameters.get("message");
                MessageCarrier messageCarrier = (MessageCarrier)parameters.get("messageCarrier");
                NodeImpl node = onEvent.getActivity();
                ExecutionImpl child = execution.createExecution();
                execution.unlock();
                child.createVariable("message", message);
                child.createVariable("messageCarrier", messageCarrier);
                child.createVariable("onEvent", onEvent);
                child.execute(node);
                return;
            } else {
                if (onAlarmActivity == null) throw new OrchestraRuntimeException("Unsupported signal parameters");
                ExecutionImpl child = execution.createExecution();
                execution.unlock();
                child.execute(onAlarmActivity);
            }
            return;
        } else if (signal == null) {
            execution.end("ended");
            BpelExecution parentExecution = execution.getParent();
            parentExecution.removeExecution(execution);
            if (!parentExecution.getExecutions().isEmpty()) return;
            parentExecution.signal("all-finished");
            return;
        } else if (signal.equals("all-finished")) {
            Collection<OpenExecution> scopeExecutions = execution.getParent().getExecutions();
            if (scopeExecutions.size() > 1) {
                execution.waitForSignal();
                return;
            } else {
                this.cancelEvents(execution);
            }
            return;
        } else if (signal.equals("scope-finished")) {
            this.cancelEvents(execution);
            return;
        } else {
            boolean found = false;
            for (OnAlarm onAlarm : this.onAlarms) {
                if (!signal.equals(onAlarm.getUuid())) continue;
                found = true;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(ON_ALARM_PARAM, onAlarm.getActivity());
                this.signal(execution, null, params);
            }
            if (found) return;
            throw new OrchestraRuntimeException("Unsupported signal " + signal);
        }
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        if (this.onEvents.isEmpty() && this.onAlarms.isEmpty()) {
            execution.end("ended");
            BpelExecution parentExecution = (BpelExecution)execution.getParent();
            parentExecution.removeExecution(execution);
            return;
        }
        this.registerEvents((BpelExecution)execution);
    }

    public void registerEvents(BpelExecution execution) {
        if (!this.onEvents.isEmpty()) {
            execution.setWaitingExecution(new WaitingExecution(execution, this));
            Environment.getFromCurrent(MessageSession.class).send(new CheckHasMessageJob(execution));
        }
        if (this.onAlarms != null) {
            for (OnAlarm onAlarm : this.onAlarms) {
                Date date = OnAlarm.computeTimer(execution, onAlarm.getDeadlineExpression(), onAlarm.getDurationExpression(), onAlarm.getRepeatEveryExpression());
                String repeat = null;
                if (onAlarm.getRepeatEveryExpression() != null) {
                    Duration repeatDuration = onAlarm.getRepeatEveryExpression().getEvaluator().evaluateDuration(execution);
                    GregorianCalendar d = new GregorianCalendar();
                    d.setTimeInMillis(0L);
                    repeatDuration.addTo(d);
                    long repeatMillis = d.getTimeInMillis();
                    repeat = Long.toString(repeatMillis) + " milliseconds";
                }
                execution.createTimer(null, onAlarm.getUuid(), null, date, repeat, null, null);
                EnvTool.getRecorder().recordTimerStarted(new TimerData(execution.getActivityInstanceUUID(), null, date));
            }
        }
        execution.waitForSignal();
    }

    @Override
    public void cancelEvents(BpelExecution execution) {
        execution.removeJobs();
        execution.resetWaitingExecution();
    }

    public void setOnAlarms(List<OnAlarm> onAlarms) {
        this.onAlarms = onAlarms;
    }

    public void setOnEvents(List<OnEvent> onEvents) {
        this.onEvents = onEvents;
    }

    @Override
    public boolean isCreateInstance() {
        return false;
    }
}

