/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.List;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AutomaticActivity;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.facade.data.def.ReplyActivityDefinitionData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.runtime.VariableRuntime;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Replier;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reply
extends AutomaticActivity {
    private static final long serialVersionUID = 1L;
    protected String partnerLinkName = null;
    protected String operationName = null;
    protected QName portTypeQName = null;
    protected String variable = null;
    protected QName faultQName = null;
    protected String messageExchange = "Orchestra default message exchange";
    protected List<Correlation> correlations = null;
    protected List<Copy> outCopies;
    protected Variable anonymousOutboundMessageVariable;

    @Override
    public void executeBusinessLogic(BpelExecution execution) {
        OperationKey operationKey = new OperationKey(execution.getProcessDefinition().getQName(), this.portTypeQName, this.operationName);
        ScopeRuntime scopeRuntime = null;
        Replier replier = execution.getReplier(operationKey, this.messageExchange);
        if (replier == null) {
            throw BpelFaultException.generateBpelFaultException(BpelFaultException.BpelFault.missingRequest);
        }
        QName msgType = null;
        MessageVariable reply = null;
        if (this.variable != null) {
            reply = (MessageVariable)execution.getVariableValue(this.variable);
            msgType = execution.getVariableByName(this.variable).getVariableDefinition().getMessageType();
        } else if (this.outCopies != null && !this.outCopies.isEmpty()) {
            scopeRuntime = execution.getCurrentScopeRuntime();
            VariableRuntime anonymousOutboundMessageVariableRuntime = scopeRuntime.createVariable(execution, this.anonymousOutboundMessageVariable);
            for (Copy copy : this.outCopies) {
                copy.execute(execution);
            }
            scopeRuntime.removeVariable(execution, this.anonymousOutboundMessageVariable);
            reply = (MessageVariable)anonymousOutboundMessageVariableRuntime.getValue();
            msgType = this.anonymousOutboundMessageVariable.getMessageType();
        }
        if (this.correlations != null) {
            for (Correlation correlation : this.correlations) {
                CorrelationSetRuntime correlationSetRuntime = execution.getCorrelationSetByName(correlation.getCorrelationSet().getName());
                correlationSetRuntime.checkCSValues(execution, reply, msgType, correlation.getInitiate());
            }
        }
        if (this.getFaultQName() == null) {
            replier.reply(reply);
        } else {
            replier.replyWithFault(this.getFaultQName(), reply);
        }
    }

    public String getOperation() {
        return this.operationName;
    }

    public void setOperation(String operation) {
        this.operationName = operation;
    }

    public String getPartnerLinkName() {
        return this.partnerLinkName;
    }

    public void setPartnerLinkName(String partnerLinkName) {
        this.partnerLinkName = partnerLinkName;
    }

    public QName getPortTypeQName() {
        return this.portTypeQName;
    }

    public void setPortTypeQName(QName portType) {
        this.portTypeQName = portType;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public List<Correlation> getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(List<Correlation> correlations) {
        this.correlations = correlations;
    }

    public QName getFaultQName() {
        return this.faultQName;
    }

    public void setFaultQName(QName faultName) {
        this.faultQName = faultName;
    }

    public String getMessageExchange() {
        return this.messageExchange;
    }

    public void setMessageExchange(String messageExchange) {
        this.messageExchange = messageExchange;
    }

    public void setOutCopies(List<Copy> outCopies) {
        this.outCopies = outCopies;
    }

    public void setAnonymousOutboundMessageVariable(Variable anonymousOutboundMessageVariable) {
        this.anonymousOutboundMessageVariable = anonymousOutboundMessageVariable;
    }

    @Override
    public ActivityType getType() {
        return ActivityType.REPLY;
    }

    @Override
    public ReplyActivityDefinitionData createDefinitionData(BpelProcess bpelProcess) {
        return new ReplyActivityDefinitionData(bpelProcess.getProcessDefinitionData(), this.uuid, null, this.name, null, null, null);
    }
}

