/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.runtime.CorrelationSetRuntime;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.var.MessageVariable;

public class Correlation
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected CorrelationSet correlationSet;
    protected Initiate initiate = Initiate.no;

    public void setInitiate(String initiate) {
        this.initiate = initiate.equals("yes") ? Initiate.yes : (initiate.equals("join") ? Initiate.join : Initiate.no);
    }

    public boolean correlationOK(MessageVariable message, ReceivingElement receivingElement, WaitingExecution waitingExecution, BpelProcess bpelProcess) {
        CorrelationSetRuntime correlationSetRuntime = null;
        for (CorrelationSetRuntime csRuntime : waitingExecution.getCorrelationSetRuntimes()) {
            if (!csRuntime.getCorrelationSetDefinition().getName().equals(this.correlationSet.getName())) continue;
            correlationSetRuntime = csRuntime;
            break;
        }
        if (correlationSetRuntime == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("CorrelationSetRuntime not found for correlation " + this.correlationSet.getName());
            sb.append("Receiving element is " + receivingElement.getOperationKey() + "(" + receivingElement.getCorrelations() + ")");
            sb.append(". Waiting execution is : " + waitingExecution + ", correlations : ");
            for (CorrelationSetRuntime csRuntime : waitingExecution.getCorrelationSetRuntimes()) {
                sb.append(csRuntime.getCorrelationSetDefinition().getName());
                sb.append(", ");
            }
            throw new OrchestraRuntimeException(sb.toString());
        }
        if (!correlationSetRuntime.isInitialized()) {
            return true;
        }
        QName messageType = receivingElement.getInputMessageType();
        return correlationSetRuntime.validateCSValues(bpelProcess.getWsdlInfos(), message, messageType);
    }

    public CorrelationSet getCorrelationSet() {
        return this.correlationSet;
    }

    public void setCorrelationSet(CorrelationSet correlationSet) {
        this.correlationSet = correlationSet;
    }

    public Initiate getInitiate() {
        return this.initiate;
    }

    public void setInitiate(Initiate initiate) {
        this.initiate = initiate;
    }

    public String toString() {
        return "correlation[" + this.correlationSet.getName() + " , initiate=" + (Object)((Object)this.initiate) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Initiate {
        yes,
        join,
        no;

    }
}

