/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.element;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.PartDefinition;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable {
    private static final long serialVersionUID = 7921696230594148306L;
    protected long dbid;
    protected int dbversion;
    protected QName messageType;
    protected QName xmlType;
    protected QName element;
    protected Map<String, PartDefinition> messageParts = new HashMap<String, PartDefinition>();
    protected Copy virtualCopy;
    protected String name;
    public static final String OUTBOUND_ANONYMOUS_WSDL_MESSAGE_NAME = "ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE";
    public static final String INBOUND_ANONYMOUS_WSDL_MESSAGE_NAME = "ORCHESTRA_4_INBOUND_WSDL_MESSAGE";
    protected Document defaultValue;

    public Copy getVirtualCopy() {
        return this.virtualCopy;
    }

    public QName getElement() {
        return this.element;
    }

    public QName getMessageType() {
        return this.messageType;
    }

    public String getName() {
        return this.name;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setVirtualCopy(Copy virtualCopy) {
        this.virtualCopy = virtualCopy;
    }

    public void setElement(QName element) {
        this.element = element;
    }

    public void setMessageType(QName messageType) {
        this.messageType = messageType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setXmlType(QName type) {
        this.xmlType = type;
    }

    public void initDefaultValue(WsdlsInfos wsdlsInfos) {
        if (this.getMessageType() != null) {
            Message message = wsdlsInfos.getMessage(this.getMessageType());
            if (message != null) {
                this.defaultValue = new MessageVariable(message).getPartsAsDocument();
                for (Object part : message.getOrderedParts(null)) {
                    Part wsdlPart = (Part)part;
                    PartDefinition partDefinition = new PartDefinition(wsdlPart.getTypeName(), wsdlPart.getElementName());
                    this.messageParts.put(wsdlPart.getName(), partDefinition);
                }
            }
        } else if (this.getXmlType() != null) {
            this.defaultValue = BpelXmlUtil.createDefaultElement().getOwnerDocument();
        } else if (this.getElement() != null) {
            this.defaultValue = XmlUtil.getDocumentWithOneElement(this.getElement()).getOwnerDocument();
        } else {
            Misc.log(Level.WARNING, "initializeXmlType : variable is not a type and is not an element... : this case is forbiden", new Object[0]);
        }
    }

    public Document getDefaultValue() {
        return this.defaultValue;
    }

    public Map<String, PartDefinition> getMessageParts() {
        return this.messageParts;
    }
}

