/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.full.impl;

import java.util.Date;
import org.ow2.orchestra.facade.runtime.VariableUpdate;
import org.ow2.orchestra.facade.runtime.full.ScopeActivityFullInstance;
import org.ow2.orchestra.facade.runtime.impl.VariableUpdateImpl;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VariableUpdateFullImpl
implements VariableUpdate {
    private static final long serialVersionUID = 4978973329065042473L;
    protected long dbid;
    protected int index;
    protected ScopeActivityFullInstance scopeActivityFullInstance;
    protected ActivityInstanceUUID activityUUID;
    protected Date date;
    protected String name;
    protected boolean isMessage = false;
    protected Document xmlValue;

    protected VariableUpdateFullImpl() {
    }

    public VariableUpdateFullImpl(VariableUpdate record, ScopeActivityFullInstance scopeActivityFullInstance) {
        this(scopeActivityFullInstance, record.getActivityUUID(), new Date(record.getDate().getTime()), record.getName(), record.getValue());
    }

    public VariableUpdateFullImpl(ScopeActivityFullInstance scopeActivityFullInstance, ActivityInstanceUUID activityUUID, Date date, String name, Object value) {
        this.scopeActivityFullInstance = scopeActivityFullInstance;
        this.activityUUID = activityUUID;
        this.date = new Date(date.getTime());
        this.name = name;
        if (value != null) {
            if (value instanceof MessageVariable) {
                this.xmlValue = ((MessageVariable)value).duplicate().getPartsAsDocument();
                this.isMessage = true;
            } else if (value instanceof Element) {
                this.xmlValue = XmlUtil.getNewDocument();
                Node n = this.xmlValue.importNode((Node)value, true);
                this.xmlValue.appendChild(n);
                this.isMessage = false;
            } else {
                Misc.unreachableStatement("unknow variable type");
            }
        }
    }

    public ActivityInstanceUUID getActivityUUID() {
        return this.activityUUID;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.isMessage) {
            return new MessageVariable(this.xmlValue);
        }
        if (this.xmlValue == null) {
            return null;
        }
        return this.xmlValue.getDocumentElement();
    }

    public String toString() {
        return "Update " + this.name + " at " + this.date + " by " + this.activityUUID + " to value [" + this.getValue() + "]";
    }

    public VariableUpdate copy() {
        return new VariableUpdateImpl(this);
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

