/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.ow2.orchestra.cluster.ClusterDescription;
import org.ow2.orchestra.cluster.LocalServer;
import org.ow2.orchestra.cluster.Server;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.ManagementAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.jmx.commands.ActivateProcessCommand;
import org.ow2.orchestra.jmx.commands.DeployCommand;
import org.ow2.orchestra.jmx.commands.DeployWSCommand;
import org.ow2.orchestra.jmx.commands.GetDeployedProcessDefinitionUUIDCommand;
import org.ow2.orchestra.jmx.commands.InitializeCommand;
import org.ow2.orchestra.jmx.commands.RemoveProcessCommand;
import org.ow2.orchestra.jmx.commands.RetireProcessCommand;
import org.ow2.orchestra.jmx.commands.UndeployCommand;
import org.ow2.orchestra.jmx.commands.UndeployWSCommand;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.util.DeploymentUtil;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementAPIImpl
implements ManagementAPI {
    private static final Logger LOG = Logger.getLogger(ManagementAPIImpl.class.getName());
    private final Server localServer;
    private final EnvironmentFactory environmentFactory;

    public ManagementAPIImpl(EnvironmentFactory environmentFactory) {
        this.localServer = new LocalServer(this);
        this.environmentFactory = environmentFactory;
    }

    public ManagementAPIImpl(Server orchestraServer, EnvironmentFactory environmentFactory) {
        this.localServer = orchestraServer;
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    public <T> T execute(Command<T> command) {
        return this.getCommandService().execute(command);
    }

    @Override
    public ProcessDefinition deploy(Deployment bpelDeployment) {
        ProcessDefinition processDefinition = this.execute(new DeployCommand(bpelDeployment));
        if (processDefinition != null) {
            try {
                this.deployWebServicesOnCluster(processDefinition.getUUID(), false);
            }
            catch (RuntimeException e) {
                this.undeployWebServicesOnCluster(processDefinition.getUUID(), true);
                this.execute(new UndeployCommand(processDefinition.getUUID()));
                throw e;
            }
        }
        return processDefinition;
    }

    private void deployWebServicesOnCluster(ProcessDefinitionUUID processDefinitionUUID, boolean ignoreExceptions) {
        Collection<Server> servers = this.getOrchestraServersInCluster();
        for (Server server : servers) {
            ManagementAPI managementAPI = null;
            if (server.equals(this.localServer)) {
                managementAPI = this;
            } else {
                try {
                    managementAPI = server.getManagementAPI();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Connection to server " + server + " failed.", e);
                }
            }
            if (managementAPI == null) continue;
            try {
                managementAPI.deployWebServices(processDefinitionUUID);
                LOG.log(Level.INFO, "Web services for process " + processDefinitionUUID + " successfully deployed on server " + server + ".");
            }
            catch (RuntimeException e) {
                if (ignoreExceptions) {
                    LOG.log(Level.WARNING, "Web services deployment for process " + processDefinitionUUID + " failed on server " + server + ".", e);
                    continue;
                }
                throw e;
            }
        }
    }

    private void undeployWebServicesOnCluster(ProcessDefinitionUUID processDefinitionUUID, boolean ignoreExceptions) {
        Collection<Server> servers = this.getOrchestraServersInCluster();
        for (Server server : servers) {
            ManagementAPI managementAPI = null;
            try {
                managementAPI = server.getManagementAPI();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Connection to server " + server + " failed.", e);
            }
            if (managementAPI == null) continue;
            try {
                managementAPI.undeployWebServices(processDefinitionUUID);
                LOG.log(Level.INFO, "Web services for process " + processDefinitionUUID + " successfully undeployed on server " + server + ".");
            }
            catch (RuntimeException e) {
                if (ignoreExceptions) {
                    LOG.log(Level.WARNING, "Web services undeployment for process " + processDefinitionUUID + " failed on server " + server + ".", e);
                    continue;
                }
                throw e;
            }
        }
    }

    private Collection<Server> getOrchestraServersInCluster() {
        return this.execute(new Command<Collection<Server>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Collection<Server> execute(Environment environment) {
                ClusterDescription clusterDescription = environment.get(ClusterDescription.class);
                if (clusterDescription != null) {
                    return clusterDescription.getOrchestraServers();
                }
                return Collections.singletonList(ManagementAPIImpl.this.localServer);
            }
        });
    }

    @Override
    public void deployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.execute(new DeployWSCommand(processDefinitionUUID));
    }

    @Override
    public void undeployWebServices(ProcessDefinitionUUID processDefinitionUUID) {
        this.execute(new UndeployWSCommand(processDefinitionUUID));
    }

    @Override
    public boolean undeploy(QName processQName) {
        ProcessDefinitionUUID processDefinitionUUID = this.execute(new GetDeployedProcessDefinitionUUIDCommand(processQName));
        return this.undeploy(processDefinitionUUID);
    }

    @Override
    public boolean undeploy(ProcessDefinitionUUID pduuid) {
        this.undeployWebServicesOnCluster(pduuid, false);
        try {
            return this.getCommandService().execute(new UndeployCommand(pduuid));
        }
        catch (RuntimeException e) {
            this.deployWebServicesOnCluster(pduuid, true);
            throw e;
        }
    }

    @Override
    public boolean remove(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getCommandService().execute(new RemoveProcessCommand(processDefinitionUUID));
    }

    @Override
    public boolean activate(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new ActivateProcessCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean retire(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new RetireProcessCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ProcessDefinition deployBar(byte[] barFile) {
        try {
            ZipEntry zipFile;
            new File(System.getProperty("java.io.tmpdir")).mkdirs();
            File tmpDir = File.createTempFile("orch", null, null);
            tmpDir.delete();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
            }
            ArrayList<URL> wsdlUrls = new ArrayList<URL>();
            URL bpelFile = null;
            ByteArrayInputStream in = new ByteArrayInputStream(barFile);
            ZipInputStream zipInput = new ZipInputStream(in);
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            while ((zipFile = zipInput.getNextEntry()) != null) {
                File outFile = new File(tmpDir.getAbsolutePath() + File.separator + zipFile.getName());
                if (zipFile.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                byte[] content = Misc.getAllContentFrom(zipInput);
                resources.put(zipFile.getName(), content);
                Misc.write(content, outFile);
                if (zipFile.getName().endsWith(".wsdl")) {
                    wsdlUrls.add(outFile.toURI().toURL());
                    continue;
                }
                if (!zipFile.getName().endsWith(".bpel")) continue;
                if (bpelFile != null) {
                    throw new OrchestraRuntimeException("Bar contains more than one bpel file.");
                }
                bpelFile = outFile.toURI().toURL();
            }
            zipInput.close();
            ((InputStream)in).close();
            Deployment deployment = DeploymentUtil.generateDeployment(bpelFile, wsdlUrls);
            deployment.getResourcesRepository().getResources().putAll(resources);
            ProcessDefinition process = this.deploy(deployment);
            Misc.deleteDir(tmpDir);
            return process;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException("Unable to deploy bar", e);
        }
    }

    @Override
    public void initialize() {
        this.getCommandService().execute(new InitializeCommand());
    }
}

