/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.QuerierDefinitionAPI;
import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.jmx.commands.FindActivityDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.FindProcessDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.GetActivityDefinitionCommand;
import org.ow2.orchestra.jmx.commands.GetProcessDefinitionCommand;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerierDefinitionAPIImpl
implements QuerierDefinitionAPI {
    private final EnvironmentFactory environmentFactory;

    public QuerierDefinitionAPIImpl(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions() {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand());
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName, ProcessState state) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(state, processName));
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(QName processName) {
        return this.getCommandService().execute(new FindProcessDefinitionsCommand(processName));
    }

    @Override
    public ProcessDefinition getProcessDefinition(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessDefinitionCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ActivityDefinition getActivityDefinition(ActivityDefinitionUUID activityDefUUID) throws ActivityNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityDefinitionCommand(activityDefUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ActivityNotFoundException) {
                throw (ActivityNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new FindActivityDefinitionsCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }
}

