/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.util.Set;
import org.ow2.orchestra.facade.RuntimeAPI;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.data.def.ProcessDefinitionData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.GetActivityDefinitionsCommand;
import org.ow2.orchestra.jmx.commands.GetInstanceCommand;
import org.ow2.orchestra.jmx.commands.GetInstancesCommand;
import org.ow2.orchestra.jmx.commands.GetInstancesOfProcessCommand;
import org.ow2.orchestra.jmx.commands.GetProcessCommand;
import org.ow2.orchestra.jmx.commands.GetProcessesCommand;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeAPIImpl
implements RuntimeAPI {
    private final EnvironmentFactory environmentFactory;

    public RuntimeAPIImpl(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    @Override
    public Set<ProcessDefinitionData> getProcesses() {
        return this.getCommandService().execute(new GetProcessesCommand());
    }

    @Override
    public ProcessDefinitionData getProcess(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetProcessCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ActivityDefinitionData> getActivityDefinitions(ProcessDefinitionUUID processUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetActivityDefinitionsCommand(processUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public Set<ProcessInstanceData> getProcessInstances() {
        return this.getCommandService().execute(new GetInstancesCommand());
    }

    @Override
    public Set<ProcessInstanceData> getProcessInstances(ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException {
        try {
            return this.getCommandService().execute(new GetInstancesOfProcessCommand(processDefinitionUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof ProcessNotFoundException) {
                throw (ProcessNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public ProcessInstanceData getProcessInstance(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        try {
            return this.getCommandService().execute(new GetInstanceCommand(processInstanceUUID));
        }
        catch (OrchestraWrapperException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e.getCause();
            }
            throw e;
        }
    }
}

