/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.HashSet;
import java.util.Set;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.facade.data.def.ActivityDefinitionData;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetActivityDefinitionsCommand
implements Command<Set<ActivityDefinitionData>> {
    private static final long serialVersionUID = -4282818977685054488L;
    private final ProcessDefinitionUUID processUUID;

    public GetActivityDefinitionsCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public Set<ActivityDefinitionData> execute(Environment environment) {
        BpelProcess bpelProcess = EnvTool.getRepository().getProcess(this.processUUID);
        if (bpelProcess == null) {
            throw new OrchestraWrapperException(new ProcessNotFoundException(this.processUUID));
        }
        HashSet<ActivityDefinitionData> result = new HashSet<ActivityDefinitionData>();
        for (Node node : bpelProcess.getNodes()) {
            AbstractActivity activity = (AbstractActivity)((NodeImpl)node).getBehaviour();
            result.add(activity.createDefinitionData(bpelProcess));
        }
        return result;
    }
}

