/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.exception.OrchestraWrapperException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.EnvTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetInstancesOfProcessCommand
implements Command<Set<ProcessInstanceData>> {
    private static final long serialVersionUID = -4282818977685054488L;
    private final ProcessDefinitionUUID processUUID;

    public GetInstancesOfProcessCommand(ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
    }

    @Override
    public Set<ProcessInstanceData> execute(Environment environment) {
        BpelProcess bpelProcess = EnvTool.getRepository().getProcess(this.processUUID);
        if (bpelProcess == null) {
            throw new OrchestraWrapperException(new ProcessNotFoundException(this.processUUID));
        }
        List<BpelExecution> bpelInstances = EnvTool.getRepository().getInstances(bpelProcess.getQName());
        HashSet<ProcessInstanceData> result = new HashSet<ProcessInstanceData>();
        for (BpelExecution bpelInstance : bpelInstances) {
            result.add(bpelInstance.getProcessInstanceData());
        }
        return result;
    }
}

