/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlDocumentInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(XmlDocumentInfo.class.getName());
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private String uri;
    private String localName;
    private String targetNamespace;

    private XmlDocumentInfo() {
    }

    public static XmlDocumentInfo createXmlDocumentInfo(byte[] bytes) {
        XmlDocumentInfo xmlDocumentInfo;
        block2: {
            xmlDocumentInfo = new XmlDocumentInfo();
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                XmlDocumentInfoHandler xmlDocumentInfoHandler = new XmlDocumentInfoHandler(xmlDocumentInfo);
                saxParser.parse((InputStream)inputStream, (DefaultHandler)xmlDocumentInfoHandler);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.INFO)) break block2;
                log.info("couldn't determine document xmlType: " + e.getMessage());
            }
        }
        return xmlDocumentInfo;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isBpelProcess() {
        return false;
    }

    public boolean isWsdl() {
        return false;
    }

    private static class XmlDocumentInfoHandler
    extends DefaultHandler {
        private boolean isRoot = true;
        private XmlDocumentInfo xmlDocumentInfo;

        public XmlDocumentInfoHandler(XmlDocumentInfo xmlDocumentInfo) {
            this.xmlDocumentInfo = xmlDocumentInfo;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.isRoot) {
                this.isRoot = false;
                this.xmlDocumentInfo.uri = uri;
                this.xmlDocumentInfo.localName = localName;
                String targetNamespaceAttribute = attributes.getValue("targetNamespace");
                if (targetNamespaceAttribute != null && !"".equals(targetNamespaceAttribute)) {
                    this.xmlDocumentInfo.targetNamespace = targetNamespaceAttribute;
                }
            }
        }
    }
}

