/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.Reply;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.definition.element.ToPart;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.ToPartDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.ReplyActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.CorrelationDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ToPartDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.parsing.binding.ActivityBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.pvm.activity.ExternalActivity;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplyBinding
extends ActivityBinding {
    private static Logger log = Logger.getLogger(ReplyBinding.class.getName());

    public ReplyBinding() {
        super("reply", ActivityType.REPLY);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        Element correlationsElement;
        String messageExchange;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        parse.addWarning("Crash recovery and clustering are not supported for process with reply activities");
        Reply reply = new Reply();
        this.setEnclosingScope(reply, parse);
        this.parseStandardAttributes(element, reply, parse);
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        this.parseStandardElements(element, reply, parse);
        reply.setVariable(XmlUtil.attribute(element, "variable"));
        String partnerLinkName = XmlUtil.attribute(element, "partnerLink");
        reply.setPartnerLinkName(partnerLinkName);
        reply.setOperation(XmlUtil.attribute(element, "operation"));
        QName faultQName = XmlUtil.attributeQName(element, "faultName");
        if (faultQName != null) {
            reply.setFaultQName(faultQName);
        }
        if ((messageExchange = XmlUtil.attribute(element, "messageExchange")) != null) {
            reply.setMessageExchange(messageExchange);
        }
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setVariable(reply.getVariable());
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setPartnerLink(reply.getPartnerLinkName());
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setOperation(reply.getOperation());
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setFaultName(reply.getFaultQName());
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setMessageExchange(reply.getMessageExchange());
        PartnerLink partnerLink = this.findPartnerLinkDefinition(parse, partnerLinkName);
        if (partnerLink == null) {
            parse.addProblem("No partnerLink " + partnerLinkName + " defined.");
            return null;
        }
        QName plportType = partnerLink.getMyRolePortTypeQName();
        if (plportType == null) {
            parse.addProblem("No myRole defined for partnerLink: " + partnerLinkName);
            return null;
        }
        reply.setPortTypeQName(plportType);
        if (XmlUtil.attribute(element, "portType") != null && !plportType.equals(XmlUtil.attributeQName(element, "portType"))) {
            String message = StaticAnalysisFault.getMessage("SA00005", "  reply " + reply.getName() + " has specified a PortType that is different from the one specified by the partnerLink");
            parse.addProblem(message, new StaticAnalysisException("SA00005"));
        }
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setPortType(reply.getPortTypeQName());
        Element toPartsElement = XmlUtil.element(element, "toParts");
        if (toPartsElement != null) {
            if (reply.getVariable() != null) {
                String message = StaticAnalysisFault.getMessage("SA00059", "  reply " + reply.getName() + " has specified both a Variable and a toPart");
                parse.addProblem(message, new StaticAnalysisException("SA00059"));
            }
            List<Element> toPartElements = XmlUtil.elements(toPartsElement, "toPart");
            this.setOutCopies(toPartElements, reply, parse);
        }
        if ((correlationsElement = XmlUtil.element(element, "correlations")) != null) {
            List<Element> correlationElements = XmlUtil.elements(correlationsElement, "correlation");
            this.parseCorrelations(correlationElements, reply, parse);
        }
        NodeImpl replyNode = this.createActivityNode(element, parse, parser, (ExternalActivity)reply);
        return replyNode;
    }

    private void setOutCopies(List<Element> toPartElements, Reply reply, Parse parse) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<ToPartDefinition> toPartDefinitionList = new ArrayList<ToPartDefinition>();
        if (toPartElements != null) {
            ArrayList<ToPart> toParts = new ArrayList<ToPart>();
            for (Element toPartElement : toPartElements) {
                ToPart toPart = new ToPart();
                String part = XmlUtil.attribute(toPartElement, "part");
                toPart.setPart(part);
                String fromVariable = XmlUtil.attribute(toPartElement, "fromVariable");
                toPart.setFromVariable(fromVariable);
                toParts.add(toPart);
                ToPartDefinitionImpl toPartDefinition = new ToPartDefinitionImpl(toPart.getFromVariable(), toPart.getPart());
                toPartDefinitionList.add(toPartDefinition);
            }
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            Operation operation = bpelProcess.getWsdlInfos().getPortType(reply.getPortTypeQName()).getOperation(reply.getOperation(), null, null);
            QName messageQName = operation.getOutput().getMessage().getQName();
            Variable anonymousOutboundMessageVariable = new Variable();
            anonymousOutboundMessageVariable.setName("ORCHESTRA_4_OUTBOUND_WSDL_MESSAGE");
            anonymousOutboundMessageVariable.setMessageType(messageQName);
            anonymousOutboundMessageVariable.initDefaultValue(parse.findObject(BpelProcess.class).getWsdlInfos());
            reply.setAnonymousOutboundMessageVariable(anonymousOutboundMessageVariable);
            String anonymousOutboundMessageVariableName = anonymousOutboundMessageVariable.getName();
            ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setToPartDefinition(toPartDefinitionList);
            ArrayList<Copy> outCopies = null;
            for (ToPart toPart : toParts) {
                if (outCopies == null) {
                    outCopies = new ArrayList<Copy>();
                }
                From from = new From();
                from.setVariable(toPart.getFromVariable());
                from.setVariant(Variant.VAR);
                To to = new To();
                to.setVariable(anonymousOutboundMessageVariableName);
                to.setPart(toPart.getPart());
                to.setVariant(Variant.VAR);
                Copy copy = new Copy();
                copy.setFrom(from);
                copy.setTo(to);
                outCopies.add(copy);
            }
            reply.setOutCopies(outCopies);
        }
    }

    private void parseCorrelations(List<Element> correlationElements, Reply reply, Parse parse) {
        ArrayList<Correlation> correlations = new ArrayList<Correlation>();
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<CorrelationDefinition> correlationDefinitionList = new ArrayList<CorrelationDefinition>();
        if (correlationElements != null) {
            for (Element correlationElement : correlationElements) {
                Correlation correlation = new Correlation();
                String set = XmlUtil.attribute(correlationElement, "set");
                Scope enclosingScope = (Scope)reply.getEnclosingScope();
                try {
                    correlation.setCorrelationSet(enclosingScope.findCorrelationSet(set));
                }
                catch (CorrelationSetNotFoundException e) {
                    parse.addProblem("A correlation has not been defined in enclosing scopes", e);
                }
                String initiate = XmlUtil.attribute(correlationElement, "initiate");
                correlation.setInitiate(initiate);
                correlations.add(correlation);
                CorrelationDefinitionImpl correlationDefinition = new CorrelationDefinitionImpl(set, initiate);
                correlationDefinitionList.add(correlationDefinition);
            }
        }
        reply.setCorrelations(correlations);
        ((ReplyActivityFullDefinitionImpl)activityFullDefinition).setCorrelationDefinition(correlationDefinitionList);
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new ReplyActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

