/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.parsing.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.EventHandlerActivity;
import org.ow2.orchestra.definition.activity.IAbstractActivity;
import org.ow2.orchestra.definition.activity.IScope;
import org.ow2.orchestra.definition.activity.Scope;
import org.ow2.orchestra.definition.element.Copy;
import org.ow2.orchestra.definition.element.CorrelationSet;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.definition.element.OnAlarm;
import org.ow2.orchestra.definition.element.OnEvent;
import org.ow2.orchestra.definition.element.PartnerLink;
import org.ow2.orchestra.definition.element.To;
import org.ow2.orchestra.definition.element.Variable;
import org.ow2.orchestra.exception.StaticAnalysisException;
import org.ow2.orchestra.facade.def.CorrelationSetDefinition;
import org.ow2.orchestra.facade.def.PartnerLinkDefinition;
import org.ow2.orchestra.facade.def.VariableDefinition;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.BpelActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.OnAlarmFullDefinition;
import org.ow2.orchestra.facade.def.full.OnEventFullDefinition;
import org.ow2.orchestra.facade.def.full.ScopeActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.impl.CopyFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.OnAlarmFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.OnEventFullDefinitionImpl;
import org.ow2.orchestra.facade.def.full.impl.ScopeActivityFullDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.CorrelationSetDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.ForDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.PartnerLinkDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.RepeatEveryDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.UntilDefinitionImpl;
import org.ow2.orchestra.facade.def.impl.VariableDefinitionImpl;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.binding.ActivityWithFCTHBinding;
import org.ow2.orchestra.parsing.binding.AssignBinding;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.parsing.binding.EventHandlerScopeBinding;
import org.ow2.orchestra.parsing.binding.PickBinding;
import org.ow2.orchestra.parsing.binding.ReceiveBinding;
import org.ow2.orchestra.parsing.binding.exception.CorrelationSetNotFoundException;
import org.ow2.orchestra.parsing.binding.exception.DuplicateVariableException;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.pvm.model.Node;
import org.ow2.orchestra.runtime.OrchestraFaultHandler;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.StaticAnalysisFault;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.wsdl.PartnerLinkType;
import org.ow2.orchestra.wsdl.Property;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeBinding
extends ActivityWithFCTHBinding {
    private static Logger log = Logger.getLogger(ScopeBinding.class.getName());

    public ScopeBinding() {
        super("scope", ActivityType.SCOPE);
    }

    public ScopeBinding(String tagName, ActivityType activityType) {
        super(tagName, activityType);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        try {
            return this.parse(element, null, parse, parser);
        }
        catch (DuplicateVariableException e) {
            parse.addProblem("Duplicate variable ", e);
            return null;
        }
    }

    protected Scope createScopeActivity() {
        return new Scope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(Element element, Set<Variable> moreVariables, Parse parse, Parser parser) throws DuplicateVariableException {
        NodeImpl scopeNode;
        Scope scope;
        block30: {
            Element correlationSetsElement;
            Element variablesElement;
            Element messageExchangesElement;
            if (log.isLoggable(Level.FINE)) {
                log.fine("parsing element = " + element);
            }
            scope = this.createScopeActivity();
            this.setEnclosingScope(scope, parse);
            this.parseStandardAttributes(element, scope, parse);
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            ScopeActivityFullDefinition activityFullDefinition = (ScopeActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
            this.parseStandardElements(element, scope, parse);
            WsdlsInfos wsdlInfos = parse.findObject(BpelProcess.class).getWsdlInfos();
            String isolatedAttr = XmlUtil.attribute(element, "isolated");
            if (isolatedAttr != null) {
                boolean isolated = BpelUtil.booleanValue(isolatedAttr, false);
                scope.setIsolated(isolated);
                if (isolated) {
                    parse.addProblem("isolated attribute not yet supported on scope activity");
                }
            }
            boolean defaultExitOnStandardFault = false;
            if (scope.getEnclosingScope() != null) {
                defaultExitOnStandardFault = ((Scope)scope.getEnclosingScope()).isExitOnStandardFault();
            }
            boolean exitOnStandardFault = BpelUtil.booleanValue(XmlUtil.attribute(element, "exitOnStandardFault"), defaultExitOnStandardFault);
            scope.setExitOnStandardFault(exitOnStandardFault);
            if (exitOnStandardFault) {
                log.warning("exitOnStandardFault attribute not yet supported on scope activity");
            }
            activityFullDefinition.setExitOnStandardFault(exitOnStandardFault);
            Element partnerLinksElement = XmlUtil.element(element, "partnerLinks");
            if (partnerLinksElement != null) {
                List<Element> partnerLinkElements = XmlUtil.elements(partnerLinksElement, "partnerLink");
                this.parsePartnerLinks(partnerLinkElements, wsdlInfos, scope, parse);
            }
            if ((messageExchangesElement = XmlUtil.element(element, "messageExchanges")) != null) {
                List<Element> messageExchangeElements = XmlUtil.elements(messageExchangesElement, "messageExchange");
                this.parseMessageExchanges(messageExchangeElements, scope, parse);
            }
            if ((variablesElement = XmlUtil.element(element, "variables")) != null) {
                List<Element> variableElements = XmlUtil.elements(variablesElement, "variable");
                this.parseVariables(variableElements, scope, parse);
            }
            if (moreVariables != null) {
                Map<String, Variable> variables = scope.getVariables();
                ArrayList<VariableDefinition> variableDefinitionList = new ArrayList<VariableDefinition>();
                if (variables == null) {
                    variables = new HashMap<String, Variable>();
                }
                for (Variable var : moreVariables) {
                    if (variables.put(var.getName(), var) != null) {
                        throw new DuplicateVariableException();
                    }
                    VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl(var.getElement(), var.getMessageType(), var.getName(), var.getXmlType());
                    variableDefinitionList.add(variableDefinition);
                }
                scope.setVariables(variables);
                activityFullDefinition.setVariableDefinition(variableDefinitionList);
            }
            if ((correlationSetsElement = XmlUtil.element(element, "correlationSets")) != null) {
                List<Element> correlationSetElements = XmlUtil.elements(correlationSetsElement, "correlationSet");
                this.parseCorrelationSets(correlationSetElements, scope, wsdlInfos, parse);
            }
            scopeNode = this.createActivityNodeWithChildren(element, parse, parser, scope);
            scope.setScopeNode(scopeNode);
            try {
                parse.pushObject(scope);
                parse.pushObject(scopeNode);
                String name = "eventHandler_" + scopeNode.getName();
                NodeImpl activity = scopeNode.createNode(name);
                EventHandlerActivity eventHandlerActivity = new EventHandlerActivity();
                ActivityDefinitionUUID processDefinitionUUID = definitionKeeper.getProcessFullDefinition().getUUID();
                ActivityDefinitionUUID activityDefinitionUUID = new ActivityDefinitionUUID((ProcessDefinitionUUID)processDefinitionUUID, definitionKeeper.getNextActivityCount(), eventHandlerActivity.getType(), eventHandlerActivity.getName());
                eventHandlerActivity.setUuid(activityDefinitionUUID);
                activity.setBehaviour(eventHandlerActivity);
                Element eventHandlersElement = XmlUtil.element(element, "eventHandlers");
                if (eventHandlersElement != null) {
                    parse.pushObject(eventHandlerActivity);
                    parse.pushObject(activity);
                    try {
                        int elements = this.parseEventHandlers(eventHandlersElement, scope, parse, parser, eventHandlerActivity);
                        if (elements < 1) {
                            String message = StaticAnalysisFault.getMessage("SA00083", "The <eventHandlers> element does not have any <onEvent> or <onAlarm> element");
                            parse.addProblem(message, new StaticAnalysisException("SA00083"));
                        }
                    }
                    finally {
                        parse.popObject();
                        parse.popObject();
                    }
                }
                this.parseTermination(element, parse, parser, scopeNode, activityFullDefinition);
                this.parseCompensation(element, parse, parser, scopeNode, activityFullDefinition);
                Element faultHandlersElement = XmlUtil.element(element, "faultHandlers");
                if (faultHandlersElement != null) {
                    parse.pushObject(faultHandlersElement);
                    try {
                        int elements = this.parseCatchAndCatchAll(faultHandlersElement, parse, parser, scopeNode, activityFullDefinition);
                        if (elements < 1) {
                            String message = StaticAnalysisFault.getMessage("SA00080", "  The <faultHandlers> element for scope \"" + scope.getName() + "\" does not have any <catch> or <catchAll> elements.");
                            parse.addProblem(message, new StaticAnalysisException("SA00080"));
                            Object var26_29 = null;
                            return var26_29;
                        }
                        break block30;
                    }
                    finally {
                        parse.popObject();
                    }
                }
                this.addDefaultFH(parse, scopeNode);
                scopeNode.addExceptionHandler(new OrchestraFaultHandler());
            }
            finally {
                parse.popObject();
                parse.popObject();
            }
        }
        List<Scope> immediatelyEnclosingScopes = this.getImmediatelyEnclosingScopes(scopeNode);
        for (Scope scope1 : immediatelyEnclosingScopes) {
            if (scope1.getName() == null || "unnamed".equals(scope1.getName())) continue;
            for (Scope scope2 : immediatelyEnclosingScopes) {
                if (scope1.getUuid().equals(scope2.getUuid()) || !scope1.getName().equals(scope2.getName())) continue;
                String message = StaticAnalysisFault.getMessage("SA00092", "  The scope name \"" + scope1.getName() + "\" is used twice in the immediately enclosing scopes of scope \"" + scope.getName() + "\"");
                parse.addProblem(message, new StaticAnalysisException("SA00092"));
            }
        }
        return scopeNode;
    }

    private List<Scope> getImmediatelyEnclosingScopes(NodeImpl node) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        if (node.getNodes() != null) {
            for (Node subNode : node.getNodes()) {
                NodeImpl subNodeImpl = (NodeImpl)subNode;
                IAbstractActivity subNodeActivity = (IAbstractActivity)subNodeImpl.getBehaviour();
                ActivityType subNodeActivityType = subNodeActivity.getType();
                if (subNodeActivityType == ActivityType.SCOPE) {
                    result.add((Scope)subNodeActivity);
                    continue;
                }
                if (subNodeActivityType == ActivityType.CATCH_HANDLER || subNodeActivityType == ActivityType.CATCHALL_HANDLER || subNodeActivityType == ActivityType.TERMINATION_HANDLER || subNodeActivityType == ActivityType.COMPENSATION_HANDLER) continue;
                result.addAll(this.getImmediatelyEnclosingScopes(subNodeImpl));
            }
        }
        return result;
    }

    private Map<String, PartnerLink> parsePartnerLinks(List<Element> partnerLinkElements, WsdlsInfos wsdlInfos, Scope scope, Parse parse) {
        HashMap<String, PartnerLink> partnerLinks = new HashMap<String, PartnerLink>();
        ArrayList<PartnerLinkDefinition> partnerLinkDefinitionList = new ArrayList<PartnerLinkDefinition>();
        if (partnerLinkElements != null) {
            for (Element partnerLinkElement : partnerLinkElements) {
                String myRoleNameDefinition = null;
                String partnerRoleNameDefinition = null;
                PartnerLink partnerLink = new PartnerLink();
                String name = XmlUtil.attribute(partnerLinkElement, "name");
                if (partnerLinks.containsKey(name)) {
                    String message = StaticAnalysisFault.getMessage("SA00018", "  PartnerLink " + name + " defined twice in scope " + scope.getName());
                    parse.addProblem(message, new StaticAnalysisException("SA00018"));
                    continue;
                }
                partnerLink.setName(name);
                QName partnerLinkTypeName = XmlUtil.attributeQName(partnerLinkElement, "partnerLinkType");
                PartnerLinkType partnerLinkType = wsdlInfos.getPartnerLinkType(partnerLinkTypeName);
                QName partnerLinkTypeDefinition = partnerLinkTypeName;
                boolean roleDef = false;
                if (partnerLinkType != null) {
                    String initializePartnerRole;
                    String partnerRoleName;
                    String myRoleName = XmlUtil.attribute(partnerLinkElement, "myRole");
                    if (myRoleName != null) {
                        QName myRolePortTypeQName = partnerLinkType.getPortTypeQName(myRoleName);
                        partnerLink.setMyRolePortTypeQName(myRolePortTypeQName);
                        roleDef = true;
                        myRoleNameDefinition = myRoleName;
                    }
                    if ((partnerRoleName = XmlUtil.attribute(partnerLinkElement, "partnerRole")) != null) {
                        QName partnerRolePortTypeQName = partnerLinkType.getPortTypeQName(partnerRoleName);
                        partnerLink.setPartnerRolePortTypeQName(partnerRolePortTypeQName);
                        roleDef = true;
                        partnerRoleNameDefinition = partnerRoleName;
                    }
                    if ((initializePartnerRole = XmlUtil.attribute(partnerLinkElement, "initializePartnerRole")) != null) {
                        if (partnerRoleName != null) {
                            partnerLink.setInitializePartnerRole(initializePartnerRole.equals("true"));
                        } else {
                            String message = StaticAnalysisFault.getMessage("SA00017", "  PartnerLink " + name + " has initializePartnerRole attribute used and does not have a partner role.");
                            parse.addProblem(message, new StaticAnalysisException("SA00017"));
                        }
                    }
                }
                if (!roleDef) {
                    String message = StaticAnalysisFault.getMessage("SA00016", "  PartnerLink " + name + " should specify myRole or partnerRole or both");
                    parse.addProblem(message, new StaticAnalysisException("SA00016"));
                    continue;
                }
                partnerLink.getDefaultEndpoints(wsdlInfos);
                partnerLinks.put(name, partnerLink);
                PartnerLinkDefinitionImpl partnerLinkDefinition = new PartnerLinkDefinitionImpl(myRoleNameDefinition, partnerLink.getName(), partnerLinkTypeDefinition, partnerRoleNameDefinition, partnerLink.getInitializePartnerRole());
                partnerLinkDefinitionList.add(partnerLinkDefinition);
            }
        }
        if (scope != null) {
            scope.setPartnerLinks(partnerLinks);
            DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
            ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
            ((ScopeActivityFullDefinition)activityFullDefinition).setPartnerLinkDefinition(partnerLinkDefinitionList);
        }
        return partnerLinks;
    }

    private Set<String> parseMessageExchanges(List<Element> messageExchangeElements, Scope scope, Parse parse) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        HashSet<String> messageExchanges = new HashSet<String>();
        if (messageExchangeElements != null) {
            for (Element messageExchangeElement : messageExchangeElements) {
                String name = XmlUtil.attribute(messageExchangeElement, "name");
                messageExchanges.add(name);
            }
        }
        if (scope != null) {
            scope.setMessageExchanges(messageExchanges);
            ((ScopeActivityFullDefinition)activityFullDefinition).setMessageExchange(messageExchanges);
        }
        return messageExchanges;
    }

    private void parseVariables(List<Element> variableElements, Scope scope, Parse parse) {
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<VariableDefinition> variableDefinitionList = new ArrayList<VariableDefinition>();
        if (variableElements != null) {
            for (Element variableElement : variableElements) {
                String message;
                Variable variable = new Variable();
                String name = XmlUtil.attribute(variableElement, "name");
                if (variables.containsKey(name)) {
                    message = StaticAnalysisFault.getMessage("SA00023", "  Variable " + name + " defined twice in scope " + scope.getName());
                    parse.addProblem(message, new StaticAnalysisException("SA00023"));
                    continue;
                }
                variable.setName(name);
                variable.setMessageType(XmlUtil.attributeQName(variableElement, "messageType"));
                variable.setXmlType(XmlUtil.attributeQName(variableElement, "type"));
                variable.setElement(XmlUtil.attributeQName(variableElement, "element"));
                variable.initDefaultValue(parse.findObject(BpelProcess.class).getWsdlInfos());
                if (!(variable.getElement() != null && variable.getMessageType() == null && variable.getXmlType() == null || variable.getElement() == null && variable.getMessageType() != null && variable.getXmlType() == null || variable.getElement() == null && variable.getMessageType() == null && variable.getXmlType() != null)) {
                    message = StaticAnalysisFault.getMessage("SA00025", "  Type of variable " + name + " not defined properly.");
                    parse.addProblem(message, new StaticAnalysisException("SA00025"));
                    continue;
                }
                Element fromElement = XmlUtil.element(variableElement, "from");
                if (fromElement != null) {
                    CopyFullDefinitionImpl copyFullDefinition = new CopyFullDefinitionImpl();
                    Copy virtualCopy = new Copy();
                    virtualCopy.setKeepSrcElementName(true);
                    AssignBinding.parseFrom(fromElement, virtualCopy, parse, scope, copyFullDefinition);
                    variable.setVirtualCopy(virtualCopy);
                    To to = new To();
                    to.setVariable(name);
                    to.setVariant(Variant.VAR);
                    virtualCopy.setTo(to);
                    scope.addVariableToBeInitialized(name);
                }
                variables.put(name, variable);
                VariableDefinitionImpl variableDefinition = new VariableDefinitionImpl(variable.getElement(), variable.getMessageType(), variable.getName(), variable.getXmlType());
                variableDefinitionList.add(variableDefinition);
            }
        }
        scope.setVariables(variables);
        ((ScopeActivityFullDefinition)activityFullDefinition).setVariableDefinition(variableDefinitionList);
    }

    private Map<String, CorrelationSet> parseCorrelationSets(List<Element> correlationSetElements, Scope scope, WsdlsInfos wsdlInfos, Parse parse) {
        HashMap<String, CorrelationSet> correlationSets = new HashMap<String, CorrelationSet>();
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ActivityFullDefinition activityFullDefinition = definitionKeeper.getActivityFullDefinition();
        ArrayList<CorrelationSetDefinition> correlationSetDefinitionList = new ArrayList<CorrelationSetDefinition>();
        if (correlationSetElements != null) {
            for (Element correlationSetElement : correlationSetElements) {
                CorrelationSet cs = new CorrelationSet();
                String name = XmlUtil.attribute(correlationSetElement, "name");
                if (correlationSets.containsKey(name) && scope != null) {
                    String message = StaticAnalysisFault.getMessage("SA00044", "  CorrelationSet " + name + " defined twice in scope " + scope.getName());
                    parse.addProblem(message, new StaticAnalysisException("SA00044"));
                    continue;
                }
                cs.setName(name);
                String propertiesSt = XmlUtil.attribute(correlationSetElement, "properties");
                HashMap<QName, Property> properties = new HashMap<QName, Property>();
                String[] propertyQNames = propertiesSt.split(" ");
                ArrayList<QName> qNameList = new ArrayList<QName>();
                for (String prop : propertyQNames) {
                    if ((prop = prop.trim()).equals("")) continue;
                    QName propertyQN = XmlUtil.getQNameFromString(correlationSetElement, prop);
                    Property property = wsdlInfos.getProperty(propertyQN);
                    properties.put(propertyQN, property);
                    qNameList.add(propertyQN);
                }
                cs.setProperties(properties);
                correlationSets.put(name, cs);
                CorrelationSetDefinitionImpl correlationSetDefinition = new CorrelationSetDefinitionImpl(name, qNameList);
                correlationSetDefinitionList.add(correlationSetDefinition);
            }
        }
        if (scope != null) {
            scope.setCorrelationSets(correlationSets);
            ((ScopeActivityFullDefinition)activityFullDefinition).setCorrelationSetDefinition(correlationSetDefinitionList);
        }
        return correlationSets;
    }

    private int parseEventHandlers(Element eventHandlersElement, IScope scope, Parse parse, Parser parser, EventHandlerActivity eventHandlerActivity) {
        DefinitionKeeper definitionKeeper = parse.findObject(DefinitionKeeper.class);
        ScopeActivityFullDefinition activityFullDefinition = (ScopeActivityFullDefinition)definitionKeeper.getActivityFullDefinition();
        ArrayList<OnEvent> onEvents = new ArrayList<OnEvent>();
        ArrayList<OnEventFullDefinition> onEventFullDefinitions = new ArrayList<OnEventFullDefinition>();
        List<Element> onEventElements = XmlUtil.elements(eventHandlersElement, "onEvent");
        if (onEventElements != null) {
            for (Element onEventElement : onEventElements) {
                OnEventFullDefinitionImpl onEventFullDefinition = new OnEventFullDefinitionImpl();
                OnEvent onEvent = this.parseOnEvent(onEventElement, scope, parse, parser, onEventFullDefinition);
                onEvents.add(onEvent);
                onEvent.setInboundMessageElement(eventHandlerActivity);
                onEventFullDefinitions.add(onEventFullDefinition);
            }
        }
        List<Element> onAlarmElements = XmlUtil.elements(eventHandlersElement, "onAlarm");
        ArrayList<OnAlarm> onAlarms = new ArrayList<OnAlarm>();
        ArrayList<OnAlarmFullDefinition> onAlarmFullDefinitions = new ArrayList<OnAlarmFullDefinition>();
        if (onAlarmElements != null) {
            for (Element onAlarmElement : onAlarmElements) {
                OnAlarmFullDefinitionImpl onAlarmFullDefinition = new OnAlarmFullDefinitionImpl();
                OnAlarm onAlarm = this.parseOnAlarm(onAlarmElement, scope, parse, parser, onAlarmFullDefinition);
                onAlarms.add(onAlarm);
                onAlarmFullDefinitions.add(onAlarmFullDefinition);
            }
        }
        activityFullDefinition.setOnEventEventHandlers(onEventFullDefinitions);
        activityFullDefinition.setOnAlarmEventHandlers(onAlarmFullDefinitions);
        eventHandlerActivity.setOnAlarms(onAlarms);
        eventHandlerActivity.setOnEvents(onEvents);
        if (!onEvents.isEmpty()) {
            BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
            bpelProcess.addInboundMessageElement(eventHandlerActivity);
        }
        return onAlarms.size() + onEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OnEvent parseOnEvent(Element element, IScope scope, Parse parse, Parser parser, OnEventFullDefinition onEventFullDefinition) {
        Element correlationsElement;
        String toVariable;
        String message;
        List<Element> partnerLinkElements;
        Map<String, PartnerLink> associatedPartnerLinks;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        OnEvent onEvent = new OnEvent();
        Element scopeElement = XmlUtil.element(element, "http://docs.oasis-open.org/wsbpel/2.0/process/executable", "scope");
        if (scopeElement == null) {
            parse.addProblem("No scope was specified under this onEvent element.");
            return null;
        }
        String partnerLinkName = XmlUtil.attribute(element, "partnerLink");
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        PartnerLink partnerLink = null;
        Element partnerLinksElement = XmlUtil.element(scopeElement, "partnerLinks");
        if (partnerLinksElement != null && (associatedPartnerLinks = this.parsePartnerLinks(partnerLinkElements = XmlUtil.elements(partnerLinksElement, "partnerLink"), bpelProcess.getWsdlInfos(), null, parse)) != null) {
            partnerLink = associatedPartnerLinks.get(partnerLinkName);
        }
        if (partnerLink == null) {
            partnerLink = this.findPartnerLinkDefinition(parse, partnerLinkName);
        }
        if (partnerLink == null) {
            String message2 = StaticAnalysisFault.getMessage("SA00084", "  onEvent " + onEvent + " defines an unknown partnerLink " + partnerLinkName + ".");
            parse.addProblem(message2, new StaticAnalysisException("SA00084"));
            return null;
        }
        onEvent.setPartnerLinkName(partnerLinkName);
        onEventFullDefinition.setPartnerLink(partnerLinkName);
        QName plportType = partnerLink.getMyRolePortTypeQName();
        if (plportType == null) {
            parse.addProblem("No myRole defined for partnerLink: " + partnerLinkName);
            return null;
        }
        QName portType = XmlUtil.attributeQName(element, "portType");
        if (portType != null && !plportType.equals(portType)) {
            String message3 = StaticAnalysisFault.getMessage("SA00005", "  onEvent " + onEvent + " has specified a PortType that is different from the one specified by the partnerLink");
            parse.addProblem(message3, new StaticAnalysisException("SA00005"));
        }
        onEventFullDefinition.setPortType(plportType);
        String operation = XmlUtil.attribute(element, "operation");
        onEventFullDefinition.setOperation(operation);
        onEvent.setOperationKey(new OperationKey(bpelProcess.getQName(), plportType, operation));
        Operation wsdlOperation = bpelProcess.getWsdlInfos().getPortType(plportType).getOperation(operation, null, null);
        Message inputMessage = wsdlOperation.getInput().getMessage();
        onEvent.setInputMessageType(inputMessage.getQName());
        HashSet<Variable> implicitVariables = new HashSet<Variable>();
        QName messageType = XmlUtil.attributeQName(element, "messageType");
        QName elementAttribute = XmlUtil.attributeQName(element, "element");
        String variable = XmlUtil.attribute(element, "variable");
        Element fromPartsElement = XmlUtil.element(element, "fromParts");
        if (variable != null) {
            String message4;
            if (messageType != null && elementAttribute != null) {
                message = StaticAnalysisFault.getMessage("SA00090", "  onEvent " + onEvent + " has specified both an element attribute and a messageType one.");
                parse.addProblem(message, new StaticAnalysisException("SA00090"));
            }
            if (messageType == null && elementAttribute == null) {
                message = StaticAnalysisFault.getMessage("SA00090", "  onEvent " + onEvent + " has specified neither an element attribute nor a messageType one.");
                parse.addProblem(message, new StaticAnalysisException("SA00090"));
            }
            Variable variableInput = new Variable();
            variableInput.setName(variable);
            variableInput.setMessageType(messageType);
            variableInput.setElement(elementAttribute);
            variableInput.initDefaultValue(parse.findObject(BpelProcess.class).getWsdlInfos());
            implicitVariables.add(variableInput);
            if (elementAttribute != null) {
                Collection messageParts = inputMessage.getParts().values();
                if (messageParts.size() != 1) {
                    String message5 = StaticAnalysisFault.getMessage("SA00087", " onEvent " + onEvent + " has specified a variable element type but the incoming message has not a single part.");
                    parse.addProblem(message5, new StaticAnalysisException("SA00087"));
                } else {
                    String message6;
                    Part part = (Part)messageParts.iterator().next();
                    if (part.getElementName() == null) {
                        message6 = StaticAnalysisFault.getMessage("SA00087", " onEvent " + onEvent + " has specified a variable element type " + "but the message single part is not defined with an element type.");
                        parse.addProblem(message6, new StaticAnalysisException("SA00087"));
                    } else if (!part.getElementName().equals(elementAttribute)) {
                        message6 = StaticAnalysisFault.getMessage("SA00087", " onEvent " + onEvent + " has specified a variable element type " + elementAttribute + "." + " According to the wsdl definition, it should be " + part.getElementName());
                        parse.addProblem(message6, new StaticAnalysisException("SA00087"));
                    } else {
                        onEvent.setAnonymousInboundMessageVariable(ReceiveBinding.getAnonymousVariable(onEvent, parse));
                        From from = new From();
                        from.setVariable("ORCHESTRA_4_INBOUND_WSDL_MESSAGE");
                        from.setPart(part.getName());
                        from.setVariant(Variant.VAR);
                        To to = new To();
                        to.setVariable(variable);
                        to.setVariant(Variant.VAR);
                        Copy copy = new Copy();
                        copy.setFrom(from);
                        copy.setTo(to);
                        onEvent.setInCopies(Collections.singletonList(copy));
                    }
                }
            } else {
                if (!inputMessage.getQName().equals(messageType)) {
                    message4 = StaticAnalysisFault.getMessage("SA00087", " onEvent " + onEvent + " has specified a variable message type " + messageType + "." + " According to the wsdl definition, it should be " + inputMessage.getQName());
                    parse.addProblem(message4, new StaticAnalysisException("SA00087"));
                }
                onEvent.setVariable(variable);
            }
            onEventFullDefinition.setVariable(variable);
            if (fromPartsElement != null) {
                message4 = StaticAnalysisFault.getMessage("SA00085", " onEvent " + onEvent + " has specified both a Variable and a fromPart");
                parse.addProblem(message4, new StaticAnalysisException("SA00085"));
            }
        } else {
            if (messageType != null || elementAttribute != null) {
                message = StaticAnalysisFault.getMessage("SA00085", "  onEvent " + onEvent + " has specified either an element attribute or a messageType one, but no variable attribute is set.");
                parse.addProblem(message, new StaticAnalysisException("SA00085"));
            }
            if (fromPartsElement != null) {
                List<Element> fromPartElements = XmlUtil.elements(fromPartsElement, "fromPart");
                onEvent.setAnonymousInboundMessageVariable(ReceiveBinding.getAnonymousVariable(onEvent, parse));
                List<Copy> inCopies = ReceiveBinding.getInCopies(fromPartElements, scope, parse, onEventFullDefinition);
                if (!inCopies.isEmpty()) {
                    onEvent.setInCopies(inCopies);
                }
                for (Element fromPartElement : fromPartElements) {
                    String part = XmlUtil.attribute(fromPartElement, "part");
                    toVariable = XmlUtil.attribute(fromPartElement, "toVariable");
                    Part wsdlPart = inputMessage.getPart(part);
                    if (wsdlPart == null) {
                        parse.addProblem("No part " + part + " defined for message: " + inputMessage.getQName());
                        return null;
                    }
                    Variable variableInput = new Variable();
                    variableInput.setName(toVariable);
                    variableInput.setXmlType(wsdlPart.getTypeName());
                    variableInput.setElement(wsdlPart.getElementName());
                    variableInput.initDefaultValue(bpelProcess.getWsdlInfos());
                    implicitVariables.add(variableInput);
                }
            }
        }
        EventHandlerScopeBinding binding = new EventHandlerScopeBinding();
        NodeImpl associatedScopeNode = null;
        DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
        defKeeper.pushParent(onEventFullDefinition);
        try {
            associatedScopeNode = (NodeImpl)binding.parse(scopeElement, implicitVariables, parse, parser);
        }
        catch (DuplicateVariableException e) {
            String message7 = StaticAnalysisFault.getMessage("SA00086", "enclosed scope declare a variable with input variable name of onEvent activity");
            parse.addProblem(message7, new StaticAnalysisException("SA00086"));
            toVariable = null;
            return toVariable;
        }
        finally {
            defKeeper.popParent();
        }
        onEvent.setActivity(associatedScopeNode);
        Scope associatedScope = (Scope)associatedScopeNode.getBehaviour();
        String messageExchange = XmlUtil.attribute(element, "messageExchange");
        if (messageExchange != null) {
            onEvent.setMessageExchange(messageExchange);
            onEventFullDefinition.setMessageExchange(messageExchange);
            boolean found = false;
            if (!found) {
                for (Scope enclosingScope = associatedScope; !found && enclosingScope != null; enclosingScope = (Scope)enclosingScope.getEnclosingScope()) {
                    found = enclosingScope.getMessageExchanges() != null && enclosingScope.getMessageExchanges().contains(messageExchange);
                }
            }
            if (!found) {
                String message8 = StaticAnalysisFault.getMessage("SA00089", "  onEvent " + onEvent + " defines an unknown messageExchange " + messageExchange + ".");
                parse.addProblem(message8, new StaticAnalysisException("SA00089"));
            }
        }
        if ((correlationsElement = XmlUtil.element(element, "correlations")) != null) {
            List<Element> correlationElements = XmlUtil.elements(correlationsElement, "correlation");
            try {
                onEvent.setCorrelations(ReceiveBinding.parseCorrelations(correlationElements, associatedScope, parse, onEventFullDefinition));
            }
            catch (CorrelationSetNotFoundException e) {
                String message9 = StaticAnalysisFault.getMessage("SA00088", "  onEvent " + onEvent + " refers to an unknown correlation set.");
                parse.addProblem(message9, new StaticAnalysisException("SA00088"));
            }
        }
        return onEvent;
    }

    private OnAlarm parseOnAlarm(Element element, IScope scope, Parse parse, Parser parser, OnAlarmFullDefinition onAlarmFullDefinition) {
        Expression expression;
        if (log.isLoggable(Level.FINE)) {
            log.fine("parsing element = " + element);
        }
        OnAlarm onAlarm = new OnAlarm();
        Element scopeElement = XmlUtil.element(element, "http://docs.oasis-open.org/wsbpel/2.0/process/executable", "scope");
        if (scopeElement == null) {
            parse.addProblem("No scope was specified under this onEvent element.");
            return null;
        }
        DefinitionKeeper defKeeper = parse.findObject(DefinitionKeeper.class);
        defKeeper.pushParent(onAlarmFullDefinition);
        EventHandlerScopeBinding binding = new EventHandlerScopeBinding();
        NodeImpl associatedScopeNode = (NodeImpl)binding.parse(scopeElement, parse, parser);
        onAlarm.setActivity(associatedScopeNode);
        defKeeper.popParent();
        BpelProcess bpelProcess = parse.findObject(BpelProcess.class);
        Element deadlineElement = XmlUtil.element(element, "until");
        Element durationElement = XmlUtil.element(element, "for");
        Element repeatEveryElement = XmlUtil.element(element, "repeatEvery");
        if (durationElement != null && deadlineElement != null) {
            parse.addProblem("Error in element: " + element + " only one element 'for' or 'until' should be used.");
        }
        if (durationElement != null) {
            expression = PickBinding.parseExpression(durationElement, bpelProcess);
            onAlarm.setDurationExpression(expression);
            ForDefinitionImpl forDefinition = new ForDefinitionImpl(expression.getLanguage(), expression.getText());
            onAlarmFullDefinition.setForDefinition(forDefinition);
        } else if (deadlineElement != null) {
            expression = PickBinding.parseExpression(deadlineElement, bpelProcess);
            onAlarm.setDeadlineExpression(expression);
            UntilDefinitionImpl untilDefinition = new UntilDefinitionImpl(expression.getLanguage(), expression.getText());
            onAlarmFullDefinition.setUntilDefinition(untilDefinition);
        } else if (repeatEveryElement == null) {
            parse.addProblem("Error in element: " + element + " one element 'for' or 'until' should be used.");
        }
        if (repeatEveryElement != null) {
            expression = PickBinding.parseExpression(repeatEveryElement, bpelProcess);
            onAlarm.setRepeatEveryExpression(expression);
            RepeatEveryDefinitionImpl repeatEveryDefinition = new RepeatEveryDefinitionImpl(expression.getLanguage(), expression.getText());
            onAlarmFullDefinition.setRepeatEveryDefinition(repeatEveryDefinition);
        }
        return onAlarm;
    }

    @Override
    public BpelActivityFullDefinition createActivityFullDefinition(ProcessDefinitionUUID processDefinitionUUID, ActivityDefinitionUUID activityDefinitionUUID, String name, Parse parse) {
        return new ScopeActivityFullDefinitionImpl(processDefinitionUUID, activityDefinitionUUID, name);
    }
}

