/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db.hibernate;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.type.NullableType;
import org.hibernate.type.TypeFactory;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEnumUserType
implements UserType,
ParameterizedType {
    private static final String DEFAULT_IDENTIFIER_METHOD_NAME = "name";
    private static final String DEFAULT_VALUE_OF_METHOD_NAME = "valueOf";
    private Class<? extends Enum> enumClass;
    private Class<?> identifierType;
    private Method identifierMethod;
    private Method valueOfMethod;
    private NullableType type;
    private int[] sqlTypes;

    @Override
    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty("enumClass");
        try {
            this.enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException cfne) {
            throw new HibernateException("Enum class not found", cfne);
        }
        String identifierMethodName = parameters.getProperty("identifierMethod", DEFAULT_IDENTIFIER_METHOD_NAME);
        try {
            this.identifierMethod = this.enumClass.getMethod(identifierMethodName, new Class[0]);
            this.identifierType = this.identifierMethod.getReturnType();
        }
        catch (Exception e) {
            throw new HibernateException("Failed to obtain identifier method", e);
        }
        this.type = (NullableType)TypeFactory.basic(this.identifierType.getName());
        if (this.type == null) {
            throw new HibernateException("Unsupported identifier type " + this.identifierType.getName());
        }
        this.sqlTypes = new int[]{this.type.sqlType()};
        String valueOfMethodName = parameters.getProperty("valueOfMethod", DEFAULT_VALUE_OF_METHOD_NAME);
        try {
            this.valueOfMethod = this.enumClass.getMethod(valueOfMethodName, this.identifierType);
        }
        catch (Exception e) {
            throw new HibernateException("Failed to obtain valueOf method", e);
        }
    }

    @Override
    public Class<?> returnedClass() {
        return this.enumClass;
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        Object identifier = this.type.get(rs, names[0]);
        if (identifier == null) {
            return null;
        }
        try {
            return this.valueOfMethod.invoke(this.enumClass, identifier);
        }
        catch (Exception e) {
            throw new HibernateException("Exception while invoking valueOf method '" + this.valueOfMethod.getName() + "' of " + "enumeration class '" + this.enumClass + "'", e);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        try {
            if (value == null) {
                st.setNull(index, this.type.sqlType());
            } else {
                Object identifier = this.identifierMethod.invoke(value, new Object[0]);
                this.type.set(st, identifier, index);
            }
        }
        catch (Exception e) {
            throw new HibernateException("Exception while invoking identifierMethod '" + this.identifierMethod.getName() + "' of " + "enumeration class '" + this.enumClass + "'", e);
        }
    }

    @Override
    public int[] sqlTypes() {
        return this.sqlTypes;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    @Override
    public Object deepCopy(Object value) {
        return value;
    }

    @Override
    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    @Override
    public boolean equals(Object x, Object y) {
        return x == y;
    }

    @Override
    public int hashCode(Object x) {
        return x.hashCode();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) {
        return original;
    }
}

