/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.deploy;

import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.deploy.Deployer;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;

public class CreateId
implements Deployer {
    private static final Log LOG = Log.getLog(CreateId.class.getName());

    public void deploy(Deployment deployment) {
        ProcessDefinitionImpl processDefinition = (ProcessDefinitionImpl)deployment.getProcessDefinition();
        if (processDefinition.getId() == null) {
            String key = processDefinition.getKey();
            if (key == null) {
                key = processDefinition.getName();
            }
            if ("".equals(key)) {
                throw new PvmException("empty string is not a valid key");
            }
            key = key.replaceAll("\\W", "_");
            String id = key + ":" + processDefinition.getVersion();
            LOG.trace("created id '" + id + "' for " + processDefinition);
            processDefinition.setId(id);
        }
    }
}

