/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.job.MessageImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.session.MessageSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutorMessageSession
implements MessageSession {
    private static final Log LOG = Log.getLog(JobExecutorMessageSession.class.getName());
    private JobDbSession jobDbSession;
    private Transaction transaction;
    private int defaultRetries = 3;
    private boolean useFairScheduling = true;
    private boolean isNotificationAdded;

    @Override
    public void send(MessageImpl<?> message) {
        LOG.debug("sending message " + ReflectUtil.getUnqualifiedClassName(message.getClass()));
        if (message.isDefaultRetries()) {
            message.setRetries(this.defaultRetries);
        }
        if (!this.useFairScheduling && message.getExecution() != null && message.getDueDate().getTime() <= System.currentTimeMillis()) {
            message.setDueDate(message.getExecution().getProcessInstance().getParentInstanceStartTime());
        }
        this.jobDbSession.save(message);
        if (!this.isNotificationAdded) {
            this.isNotificationAdded = true;
            LOG.trace("registering job executor notifier with " + this.transaction);
            JobExecutor jobExecutor = Environment.getCurrent().get(JobExecutor.class);
            if (jobExecutor == null) {
                throw new PvmException("no job executor configured to execute " + message);
            }
            this.transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
        }
    }

    public void setDefaultRetries(int defaultRetries) {
        this.defaultRetries = defaultRetries;
    }

    public void setUseFairScheduling(boolean useFairScheduling) {
        this.useFairScheduling = useFairScheduling;
    }
}

