/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.tx;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.tx.StandardResource;

public class HibernateSessionResource
implements StandardResource {
    private static final Log LOG = Log.getLog(HibernateSessionResource.class.getName());
    protected Session session;
    protected Transaction transaction;

    public HibernateSessionResource(Session session) {
        this.session = session;
        if (LOG.isTraceEnabled()) {
            LOG.trace("beginning transaction on hibernate session " + System.identityHashCode(session));
        }
        try {
            this.transaction = session.beginTransaction();
        }
        catch (RuntimeException e) {
            LOG.error("hibernate transaction begin failed.  closing hibernate session", e);
            session.close();
            throw e;
        }
        LOG.debug("begun hibernate transaction " + System.identityHashCode(this.transaction) + " on hibernate session " + System.identityHashCode(session));
    }

    public void prepare() {
        LOG.debug("flushing hibernate session " + System.identityHashCode(this.session));
        this.session.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        LOG.debug("committing hibernate transaction " + System.identityHashCode(this.transaction));
        try {
            this.transaction.commit();
        }
        finally {
            this.closeSession();
        }
    }

    private void closeSession() {
        LOG.debug("closing hibernate session " + System.identityHashCode(this.session));
        this.session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        LOG.debug("rolling back hibernate transaction " + System.identityHashCode(this.transaction));
        try {
            this.transaction.rollback();
        }
        finally {
            this.closeSession();
        }
    }
}

