/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.binding.WireOperationBinding;
import org.ow2.orchestra.pvm.internal.wire.operation.FieldOperation;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class FieldBinding
extends WireOperationBinding {
    public FieldBinding() {
        super("field");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        FieldOperation fieldOperation = new FieldOperation();
        if (element.hasAttribute("name")) {
            fieldOperation.setFieldName(element.getAttribute("name"));
        } else {
            parse.addProblem("field must have name : " + XmlUtil.toString(element));
        }
        Element descriptorElement = XmlUtil.element(element);
        if (descriptorElement != null) {
            Descriptor descriptor = (Descriptor)parser.parseElement(descriptorElement, parse, "descriptor");
            if (descriptor != null) {
                fieldOperation.setDescriptor(descriptor);
            } else {
                parse.addProblem("unknown descriptor element " + descriptorElement.getTagName() + " inside field operation: " + XmlUtil.toString(element));
            }
        } else {
            parse.addProblem("field must have 1 descriptor element out of " + parser.getBindings().getTagNames("descriptor") + " as content: " + XmlUtil.toString(element));
        }
        return fieldOperation;
    }
}

