/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.binding.PropertiesBinding;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.HibernateConfigurationDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.PropertiesDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class HibernateConfigurationBinding
extends WireDescriptorBinding {
    private static final Log LOG = Log.getLog(HibernateConfigurationBinding.class.getName());
    private static final PropertiesBinding propertiesBinding = new PropertiesBinding();
    private static final MappingParser mappingParser = new MappingParser();

    public HibernateConfigurationBinding() {
        super("hibernate-configuration");
    }

    protected HibernateConfigurationBinding(String tagName) {
        super(tagName);
    }

    static void parseMapping(Element element, HibernateConfigurationDescriptor descriptor, Parse parse) {
        if (element.hasAttribute("resource")) {
            String resource = element.getAttribute("resource");
            LOG.trace("adding hibernate configuration resource " + resource);
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddResource(resource));
        } else if (element.hasAttribute("file")) {
            String fileName = element.getAttribute("file");
            LOG.trace("adding hibernate configuration file " + fileName);
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddFile(fileName));
        } else if (element.hasAttribute("class")) {
            String className = element.getAttribute("class");
            LOG.trace("adding hibernate configuration class " + className);
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddClass(className));
        } else if (element.hasAttribute("url")) {
            String urlText = element.getAttribute("url");
            LOG.trace("adding hibernate configuration url " + urlText);
            descriptor.addMappingOperation(new HibernateConfigurationDescriptor.AddUrl(urlText));
        } else {
            parse.addProblem("exactly 1 attribute in {resource, file, class, url} was expected in mapping: " + XmlUtil.toString(element));
        }
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        List<Element> configElements;
        HibernateConfigurationDescriptor descriptor = new HibernateConfigurationDescriptor();
        String configurationClassName = null;
        if (element.hasAttribute("class")) {
            configurationClassName = element.getAttribute("class");
        }
        descriptor.setClassName(configurationClassName);
        if (element.hasAttribute("schema-operation")) {
            String schemaOperation = element.getAttribute("schema-operation");
            if ("create".equals(schemaOperation)) {
                descriptor.setSchemaOperation(HibernateConfigurationDescriptor.CreateSchema.getInstance());
            } else if ("update".equals(schemaOperation)) {
                descriptor.setSchemaOperation(HibernateConfigurationDescriptor.UpdateSchema.getInstance());
            }
        }
        if ((configElements = XmlUtil.elements(element)) != null) {
            for (Element configElement : configElements) {
                if ("mappings".equals(XmlUtil.getTagLocalName(configElement))) {
                    if (!configElement.hasAttribute("resource")) continue;
                    String resources = configElement.getAttribute("resource");
                    try {
                        URL url = ReflectUtil.getResource(parse.getClassLoader(), resources);
                        if (url == null) continue;
                        LOG.trace("importing mappings from " + url);
                        InputStream inputStream = url.openStream();
                        mappingParser.createParse().pushObject(descriptor).setInputStream(inputStream).execute();
                    }
                    catch (Exception e) {
                        parse.addProblem("couldn't parse hibernate mapping resources '" + resources + "'", e);
                    }
                    continue;
                }
                if ("mapping".equals(XmlUtil.getTagLocalName(configElement))) {
                    HibernateConfigurationBinding.parseMapping(configElement, descriptor, parse);
                    continue;
                }
                if ("properties".equals(XmlUtil.getTagLocalName(configElement))) {
                    PropertiesDescriptor propertiesDescriptor = (PropertiesDescriptor)propertiesBinding.parse(configElement, parse, parser);
                    descriptor.setPropertiesDescriptor(propertiesDescriptor);
                    continue;
                }
                if ("cache-configuration".equals(XmlUtil.getTagLocalName(configElement))) {
                    String cacheUsage = configElement.getAttribute("usage");
                    if (!("read-only".equals(cacheUsage) || "nonstrict-read-write".equals(cacheUsage) || "read-write".equals(cacheUsage) || "transactional".equals(cacheUsage))) {
                        parse.addProblem("problem in cache-configuration: no usage attribute or illegal value: " + cacheUsage + " Possible values are {read-only, nonstrict-read-write, read-write, transactional}");
                        continue;
                    }
                    parser.importExternalReferences(configElement, parse);
                    List<Element> cacheElements = XmlUtil.elements(configElement);
                    if (cacheElements == null) continue;
                    for (Element cacheElement : cacheElements) {
                        if ("class-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                            String className = cacheElement.getAttribute("class");
                            descriptor.addCacheOperation(new HibernateConfigurationDescriptor.SetCacheConcurrencyStrategy(className, cacheUsage));
                            continue;
                        }
                        if ("collection-cache".equals(XmlUtil.getTagLocalName(cacheElement))) {
                            String collection = cacheElement.getAttribute("collection");
                            descriptor.addCacheOperation(new HibernateConfigurationDescriptor.SetCollectionCacheConcurrencyStrategy(collection, cacheUsage));
                            continue;
                        }
                        parse.addProblem("unknown hibernate cache configuration element " + XmlUtil.toString(configElement));
                    }
                    continue;
                }
                parse.addProblem("unknown hibernate configuration element " + XmlUtil.toString(configElement));
            }
        }
        return descriptor;
    }

    static class MappingParser
    extends Parser {
        MappingParser() {
        }

        public Object parseDocumentElement(Element documentElement, Parse parse) {
            List<Element> elements = XmlUtil.elements(documentElement, "mapping");
            if (elements != null) {
                HibernateConfigurationDescriptor descriptor = parse.findObject(HibernateConfigurationDescriptor.class);
                for (Element element : elements) {
                    HibernateConfigurationBinding.parseMapping(element, descriptor, parse);
                }
            }
            return null;
        }
    }
}

