/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.jdk.JdkJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.pvm.PvmJobExecutor;
import org.ow2.orchestra.pvm.internal.util.PvmXmlUtil;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ContextTypeRefDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.FalseDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.IntegerDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.JobExecutorDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ReferenceDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.StringDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.TrueDescriptor;
import org.ow2.orchestra.pvm.internal.wire.operation.InvokeOperation;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class JobExecutorBinding
extends WireDescriptorBinding {
    public JobExecutorBinding() {
        super("job-executor");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String type = "default";
        if (element.hasAttribute("type")) {
            type = element.getAttribute("type");
        }
        JobExecutorDescriptor descriptor = null;
        if (type.equals("default")) {
            descriptor = new JobExecutorDescriptor((Class<? extends JobExecutor>)PvmJobExecutor.class);
            this.parseIntAttribute(element, "idle-max", descriptor, "idleMillisMax", parse);
            this.parseIntAttribute(element, "history", descriptor, "historySize", parse);
            this.parseIntAttribute(element, "threads", descriptor, "nbrOfThreads", parse);
        } else if (type.equals("jdk")) {
            descriptor = new JobExecutorDescriptor((Class<? extends JobExecutor>)JdkJobExecutor.class);
        } else {
            parse.addProblem("JobExecutor type: " + type + " is not supported.");
            return null;
        }
        if (element.hasAttribute("command-service")) {
            descriptor.addInjection("commandService", new ReferenceDescriptor(element.getAttribute("command-service")));
        } else {
            descriptor.addInjection("commandService", new ContextTypeRefDescriptor(CommandService.class));
        }
        if (element.hasAttribute("dead-job-handler")) {
            descriptor.addInjection("deadJobHandler", new ReferenceDescriptor(element.getAttribute("dead-job-handler")));
        } else {
            descriptor.addInjection("deadJobHandler", new ContextTypeRefDescriptor(DeadJobHandler.class));
        }
        if (element.hasAttribute("name")) {
            descriptor.addInjection("name", new StringDescriptor(element.getAttribute("name")));
        }
        this.parseIntAttribute(element, "idle", descriptor, "idleMillis", parse);
        this.parseIntAttribute(element, "lock", descriptor, "lockMillis", parse);
        if (PvmXmlUtil.attributeBoolean(element, "limit-job-per-instance", false, parse, false).booleanValue()) {
            descriptor.addInjection("limitSameInstanceJobs", new TrueDescriptor());
        } else {
            descriptor.addInjection("limitSameInstanceJobs", new FalseDescriptor());
        }
        if (PvmXmlUtil.attributeBoolean(element, "auto-start", false, parse, true).booleanValue()) {
            InvokeOperation invokeStartOperation = new InvokeOperation();
            invokeStartOperation.setMethodName("start");
            descriptor.addOperation(invokeStartOperation);
            descriptor.setAutoStart(true);
        }
        return descriptor;
    }

    private void parseIntAttribute(Element element, String attributeName, ObjectDescriptor descriptor, String fieldName, Parse parse) {
        Integer intValue = PvmXmlUtil.attributeInteger(element, attributeName, false, parse);
        if (intValue != null) {
            descriptor.addInjection(fieldName, new IntegerDescriptor(intValue));
        }
    }
}

