/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import org.ow2.orchestra.pvm.internal.wire.binding.WireInterceptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.RetryInterceptorDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class RetryInterceptorBinding
extends WireInterceptorBinding {
    public RetryInterceptorBinding() {
        super("retry-interceptor");
    }

    protected RetryInterceptorDescriptor createRetryInterceptorDescriptor() {
        return new RetryInterceptorDescriptor();
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        String delayText;
        RetryInterceptorDescriptor retryInterceptorDescriptor = this.createRetryInterceptorDescriptor();
        if (element.hasAttribute("retries")) {
            String retriesText = element.getAttribute("retries");
            try {
                int retries = Integer.parseInt(retriesText);
                retryInterceptorDescriptor.setRetries(retries);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse retries " + retriesText);
            }
        }
        if (element.hasAttribute("delay")) {
            delayText = element.getAttribute("delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptorDescriptor.setDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText);
            }
        }
        if (element.hasAttribute("max-delay")) {
            delayText = element.getAttribute("max-delay");
            try {
                long delay = Long.parseLong(delayText);
                retryInterceptorDescriptor.setMaxDelay(delay);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay " + delayText);
            }
        }
        if (element.hasAttribute("delay-factor")) {
            String delayFactorText = element.getAttribute("delay-factor");
            try {
                int delayFactor = Integer.parseInt(delayFactorText);
                retryInterceptorDescriptor.setDelayFactor(delayFactor);
            }
            catch (NumberFormatException e) {
                parse.addProblem("couldn't parse delay-factor " + delayFactorText);
            }
        }
        return retryInterceptorDescriptor;
    }
}

