/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.binding;

import java.util.List;
import org.ow2.orchestra.pvm.internal.type.Converter;
import org.ow2.orchestra.pvm.internal.type.Matcher;
import org.ow2.orchestra.pvm.internal.type.Type;
import org.ow2.orchestra.pvm.internal.type.TypeMapping;
import org.ow2.orchestra.pvm.internal.type.matcher.ClassNameMatcher;
import org.ow2.orchestra.pvm.internal.type.matcher.HibernateLongIdMatcher;
import org.ow2.orchestra.pvm.internal.type.matcher.HibernateStringIdMatcher;
import org.ow2.orchestra.pvm.internal.type.matcher.SerializableMatcher;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.binding.WireDescriptorBinding;
import org.ow2.orchestra.pvm.internal.wire.descriptor.VariableTypeResolverDescriptor;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.pvm.internal.xml.Parser;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class VariableTypesBinding
extends WireDescriptorBinding {
    public VariableTypesBinding() {
        super("variable-types");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        parser.importExternalReferences(element, parse);
        VariableTypeResolverDescriptor variableTypeResolverDescriptor = new VariableTypeResolverDescriptor();
        List<Element> typeElements = XmlUtil.elements(element, "type");
        if (typeElements != null) {
            for (Element typeElement : typeElements) {
                TypeMapping typeMapping = this.parseTypeMapping(typeElement, parse, parser);
                variableTypeResolverDescriptor.addTypeMapping(typeMapping);
            }
        }
        return variableTypeResolverDescriptor;
    }

    protected TypeMapping parseTypeMapping(Element element, Parse parse, Parser parser) {
        TypeMapping typeMapping = new TypeMapping();
        Type type = new Type();
        typeMapping.setType(type);
        if (element.hasAttribute("name")) {
            type.setName(element.getAttribute("name"));
        }
        String hibernateSessionFactoryName = XmlUtil.attribute(element, "hibernate-session-factory");
        Matcher matcher = null;
        if (element.hasAttribute("class")) {
            String className = element.getAttribute("class");
            if ("serializable".equals(className)) {
                matcher = new SerializableMatcher();
            } else if ("persistable".equals(className)) {
                if (element.hasAttribute("id-type")) {
                    String idType = element.getAttribute("id-type");
                    if ("long".equalsIgnoreCase(idType)) {
                        matcher = new HibernateLongIdMatcher(hibernateSessionFactoryName);
                    } else if ("string".equalsIgnoreCase(idType)) {
                        matcher = new HibernateStringIdMatcher(hibernateSessionFactoryName);
                    } else {
                        parse.addProblem("id-type was not 'long' or 'string': " + idType);
                    }
                } else {
                    parse.addProblem("id-type is required in a persistable type");
                }
            } else {
                matcher = new ClassNameMatcher(className);
            }
        } else {
            Element matcherElement = XmlUtil.element(element, "matcher");
            Element matcherObjectElement = XmlUtil.element(matcherElement);
            if (matcherObjectElement != null) {
                Object matcherObject = parser.parseElement(matcherObjectElement, parse);
                try {
                    matcher = (Matcher)matcherObject;
                }
                catch (ClassCastException e) {
                    parse.addProblem("matcher is not a " + Matcher.class.getName() + ": " + (matcherObject != null ? matcherObject.getClass().getName() : "null"));
                }
            } else {
                parse.addProblem("no matcher specified in " + XmlUtil.toString(element));
            }
        }
        typeMapping.setMatcher(matcher);
        Converter converter = null;
        if (element.hasAttribute("converter")) {
            String converterClassName = element.getAttribute("converter");
            ClassLoader classLoader = parse.getClassLoader();
            try {
                Class<?> converterClass = ReflectUtil.loadClass(classLoader, converterClassName);
                converter = (Converter)converterClass.newInstance();
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate converter " + converterClassName);
            }
        } else {
            Element converterElement = XmlUtil.element(element, "converter");
            Element converterObjectElement = XmlUtil.element(converterElement);
            if (converterObjectElement != null) {
                Object converterObject = parser.parseElement(converterObjectElement, parse);
                try {
                    converter = (Converter)converterObject;
                }
                catch (ClassCastException e) {
                    parse.addProblem("converter is not a " + Converter.class.getName() + ": " + (converterObject != null ? converterObject.getClass().getName() : "null"));
                }
            }
        }
        type.setConverter(converter);
        Class<?> variableClass = null;
        if (element.hasAttribute("variable-class")) {
            String variableClassName = element.getAttribute("variable-class");
            ClassLoader classLoader = parse.getClassLoader();
            try {
                variableClass = ReflectUtil.loadClass(classLoader, variableClassName);
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate variable-class " + variableClassName, e);
            }
        } else {
            parse.addProblem("variable-class is required on a type: " + XmlUtil.toString(element));
        }
        type.setVariableClass(variableClass);
        return typeMapping;
    }
}

