/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ow2.orchestra.pvm.internal.xml.Binding;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bindings {
    protected Map<String, List<Binding>> bindings = null;

    public Bindings() {
    }

    public Bindings(Bindings other) {
        if (other.bindings != null) {
            this.bindings = new HashMap<String, List<Binding>>();
            Set<String> categorieNames = other.bindings.keySet();
            if (categorieNames != null) {
                for (String categoryName : categorieNames) {
                    List<Binding> categoryBindings = other.bindings.get(categoryName);
                    ArrayList<Binding> categoryBindingsCopy = new ArrayList<Binding>(categoryBindings);
                    this.bindings.put(categoryName, categoryBindingsCopy);
                }
            }
        }
    }

    public Binding getBinding(Element element) {
        return this.getBinding(element, (String)null);
    }

    public Binding getBinding(Element element, String category) {
        if (this.bindings == null) {
            return null;
        }
        if (category == null) {
            for (List<Binding> categoryBindings : this.bindings.values()) {
                Binding binding = this.getBinding(element, categoryBindings);
                if (binding == null) continue;
                return binding;
            }
        } else {
            List<Binding> categoryBindings = this.bindings.get(category);
            if (categoryBindings != null) {
                return this.getBinding(element, categoryBindings);
            }
        }
        return null;
    }

    protected Binding getBinding(Element element, List<Binding> categoryBindings) {
        for (Binding binding : categoryBindings) {
            if (!binding.matches(element)) continue;
            return binding;
        }
        return null;
    }

    public void addBinding(Binding binding) {
        String category;
        List<Binding> categoryBindings;
        if (this.bindings == null) {
            this.bindings = new HashMap<String, List<Binding>>();
        }
        if ((categoryBindings = this.bindings.get(category = binding.getCategory())) == null) {
            categoryBindings = new ArrayList<Binding>();
            this.bindings.put(category, categoryBindings);
        }
        categoryBindings.add(binding);
    }

    public Set<String> getTagNames(String category) {
        List<Binding> categoryBindings = this.bindings != null ? this.bindings.get(category) : null;
        HashSet<String> tagNames = new HashSet<String>();
        if (categoryBindings != null) {
            for (Binding binding : categoryBindings) {
                tagNames.add(binding.toString());
            }
        }
        return tagNames;
    }

    public Map<String, List<Binding>> getBindings() {
        return this.bindings;
    }
}

