/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.activity.Activity;
import org.ow2.orchestra.pvm.client.ClientProcessDefinition;
import org.ow2.orchestra.pvm.internal.model.CompositeElementImpl;
import org.ow2.orchestra.pvm.internal.model.EventImpl;
import org.ow2.orchestra.pvm.internal.model.EventListenerReference;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ObservableElementImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.pvm.internal.model.TimerDefinitionImpl;
import org.ow2.orchestra.pvm.internal.model.TransitionImpl;
import org.ow2.orchestra.pvm.internal.model.VariableDefinitionImpl;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.ow2.orchestra.pvm.internal.wire.descriptor.StringDescriptor;
import org.ow2.orchestra.pvm.listener.EventListener;
import org.ow2.orchestra.pvm.model.Condition;
import org.ow2.orchestra.pvm.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFactory {
    protected ProcessDefinitionImpl processDefinition;
    protected NodeImpl node;
    protected TransitionImpl transition;
    protected List<DestinationReference> destinationReferences;
    protected ObservableElementImpl observableElement;
    protected EventImpl event;
    protected EventListenerReference eventListenerReference;
    protected ExceptionHandlerImpl exceptionHandler;
    protected CompositeElementImpl compositeElement;
    protected CompositeElementImpl scope;
    protected Stack<CompositeElementImpl> compositeElementStack;

    protected ProcessFactory() {
        this(null);
    }

    protected ProcessFactory(String processName) {
        this(processName, null);
    }

    protected ProcessFactory(String processName, ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition != null ? processDefinition : this.instantiateProcessDefinition();
        this.processDefinition.setName(processName);
        this.observableElement = this.processDefinition;
        this.compositeElement = this.processDefinition;
        this.scope = this.processDefinition;
    }

    public static ProcessFactory build() {
        return new ProcessFactory();
    }

    public static ProcessFactory build(String processName) {
        return new ProcessFactory(processName);
    }

    public static ProcessFactory build(String processName, ProcessDefinitionImpl processDefinition) {
        return new ProcessFactory(processName, processDefinition);
    }

    protected ProcessDefinitionImpl instantiateProcessDefinition() {
        return new ProcessDefinitionImpl();
    }

    public ProcessFactory initial() {
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        if (this.processDefinition.getInitial() != null) {
            throw new PvmException("duplicate initial node");
        }
        this.processDefinition.setInitial(this.node);
        return this;
    }

    public ProcessFactory scope() {
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setLocalScope(true);
        this.scope = this.node;
        return this;
    }

    public ProcessFactory variable(String key) {
        if (this.node != null) {
            this.scope();
        }
        VariableDefinitionImpl variableDefinition = this.compositeElement.createVariableDefinition();
        variableDefinition.setKey(key);
        return this;
    }

    public ProcessFactory variable(Descriptor sourceDescriptor) {
        if (this.node != null && this.scope == null) {
            this.scope();
        }
        VariableDefinitionImpl variableDefinition = this.scope.createVariableDefinition();
        variableDefinition.setKey(sourceDescriptor.getName());
        variableDefinition.setSourceDescriptor(sourceDescriptor);
        return this;
    }

    public ProcessFactory variable(String key, String initialValue) {
        return this.variable(new StringDescriptor(key, initialValue));
    }

    public ProcessFactory timer(String dueDateDescription, String signalName) {
        return this.timer(dueDateDescription, null, signalName, null);
    }

    public ProcessFactory timer(String dueDateDescription, String signalName, String repeat) {
        return this.timer(dueDateDescription, null, signalName, repeat);
    }

    public ProcessFactory timer(Date dueDate, String signalName) {
        return this.timer(null, dueDate, signalName, null);
    }

    protected ProcessFactory timer(String dueDateDescription, Date dueDate, String signalName, String repeat) {
        if (this.node != null && this.scope == null) {
            this.scope();
        }
        TimerDefinitionImpl timerDefinition = this.scope.createTimerDefinition();
        if (dueDate != null) {
            timerDefinition.setDueDate(dueDate);
        } else {
            timerDefinition.setDueDateDescription(dueDateDescription);
        }
        timerDefinition.setSignalName(signalName);
        timerDefinition.setRepeat(repeat);
        return this;
    }

    public ProcessFactory node() {
        return this.node(null);
    }

    public ProcessFactory node(String nodeName) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.setNodeName(nodeName);
        } else {
            this.node = this.compositeElement.createNode(nodeName);
            this.scope = null;
            this.observableElement = this.node;
            this.event = null;
            this.eventListenerReference = null;
            this.transition = null;
            this.exceptionHandler = null;
        }
        return this;
    }

    public ProcessFactory behaviour(Activity activity) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setBehaviour(activity);
        return this;
    }

    public ProcessFactory behaviour(Descriptor descriptor) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setBehaviour(descriptor);
        return this;
    }

    public ProcessFactory behaviour(Class<? extends Activity> activityClass) {
        return this.behaviour(new ObjectDescriptor(activityClass));
    }

    public ProcessFactory behaviour(String expression) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setBehaviour(expression);
        return this;
    }

    public ProcessFactory asyncExecute() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setExecutionAsync(true);
        return this;
    }

    public ProcessFactory asyncLeave() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setLeaveAsync(true);
        return this;
    }

    public ProcessFactory asyncSignal() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setSignalAsync(true);
        return this;
    }

    public ProcessFactory needsPrevious() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.node == null) {
            throw new PvmException("no current node");
        }
        this.node.setPreviousNeeded(true);
        return this;
    }

    public ProcessFactory compositeNode() {
        return this.compositeNode(null);
    }

    public ProcessFactory compositeNode(String nodeName) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.compositeElementStack == null) {
            this.compositeElementStack = new Stack();
        }
        this.compositeElementStack.push(this.compositeElement);
        this.node(nodeName);
        this.compositeElement = this.node;
        return this;
    }

    public ProcessFactory compositeEnd() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.compositeElementStack == null) {
            throw new PvmException("no composite node was started");
        }
        this.compositeElement = this.compositeElementStack.pop();
        if (this.compositeElementStack.isEmpty()) {
            this.compositeElementStack = null;
        }
        return this;
    }

    public ProcessFactory transition() {
        return this.transition(null);
    }

    public ProcessFactory transition(String transitionName) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.setTransitionName(transitionName);
        } else {
            if (this.node == null) {
                throw new PvmException("no current node");
            }
            this.transition = this.node.createOutgoingTransition(null, transitionName);
            this.observableElement = this.transition;
            this.event = null;
            this.eventListenerReference = null;
            this.exceptionHandler = null;
        }
        return this;
    }

    public ProcessFactory asyncTake() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.transition == null) {
            throw new PvmException("no current transition");
        }
        this.transition.setTakeAsync(true);
        return this;
    }

    public ProcessFactory to(String destination) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.transition == null) {
            throw new PvmException("no current transition");
        }
        if (this.destinationReferences == null) {
            this.destinationReferences = new ArrayList<DestinationReference>();
        }
        this.destinationReferences.add(new DestinationReference(this.transition, destination));
        return this;
    }

    public ProcessFactory waitCondition(Condition condition) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.transition == null) {
            throw new PvmException("no current transition");
        }
        ProvidedObjectDescriptor conditionDescriptor = new ProvidedObjectDescriptor(condition);
        this.transition.setWaitConditionDescriptor(conditionDescriptor);
        return this;
    }

    public ProcessFactory guardCondition(Condition condition) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.transition == null) {
            throw new PvmException("no current transition");
        }
        ProvidedObjectDescriptor conditionDescriptor = new ProvidedObjectDescriptor(condition);
        this.transition.setConditionDescriptor(conditionDescriptor);
        return this;
    }

    public ProcessFactory event(String eventName) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.observableElement == null) {
            throw new PvmException("no current process element");
        }
        if (this.observableElement instanceof Transition) {
            throw new PvmException("for actions on transitions, you don't need to call event");
        }
        this.event = this.observableElement.createEvent(eventName);
        this.exceptionHandler = null;
        return this;
    }

    public ProcessFactory exceptionHandler(Class<? extends Exception> exceptionClass) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        ProcessElementImpl processElement = null;
        if (this.eventListenerReference != null) {
            processElement = this.eventListenerReference;
        } else if (this.event != null) {
            processElement = this.event;
        } else if (this.observableElement != null) {
            processElement = this.observableElement;
        } else {
            throw new PvmException("no current process element, event or action");
        }
        this.exceptionHandler = processElement.createExceptionHandler();
        if (exceptionClass != null) {
            this.exceptionHandler.setExceptionClassName(exceptionClass.getName());
        }
        return this;
    }

    public ProcessFactory exceptionHandlerEnd() {
        this.exceptionHandler = null;
        return this;
    }

    public ProcessFactory transactional() {
        if (this.exceptionHandler == null) {
            throw new PvmException("transactional is a property of an exception handler");
        }
        this.exceptionHandler.setTransactional(true);
        return this;
    }

    public ProcessFactory listener(Descriptor descriptor) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.createEventListenerReference(descriptor);
        } else {
            this.getEvent().createEventListenerReference(descriptor);
        }
        return this;
    }

    public ProcessFactory listener(EventListener eventListener) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.createEventListenerReference(eventListener);
        } else {
            this.eventListenerReference = this.getEvent().createEventListenerReference(eventListener);
        }
        return this;
    }

    public ProcessFactory listener(String expression) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.createActivityReference(expression);
        } else {
            this.eventListenerReference = this.getEvent().createEventListenerReference(expression);
        }
        return this;
    }

    public ProcessFactory propagationDisabled() {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.eventListenerReference == null) {
            throw new PvmException("no current event action");
        }
        this.eventListenerReference.setPropagationEnabled(false);
        return this;
    }

    private EventImpl getEvent() {
        if (this.event == null && this.observableElement instanceof TransitionImpl) {
            this.event = ((TransitionImpl)this.observableElement).createEvent();
            return this.event;
        }
        if (this.event == null) {
            throw new PvmException("no current event");
        }
        return this.event;
    }

    public ProcessFactory property(String name, String stringValue) {
        StringDescriptor stringDescriptor = new StringDescriptor();
        stringDescriptor.setName(name);
        stringDescriptor.setValue(stringValue);
        this.property(stringDescriptor);
        return this;
    }

    public ProcessFactory property(Descriptor descriptor) {
        if (this.exceptionHandler != null) {
            throw new PvmException("exceptionHandler needs to be closed with exceptionHandlerEnd");
        }
        if (this.observableElement == null) {
            throw new PvmException("no current process element");
        }
        if (this.event != null) {
            this.event.addProperty(descriptor);
        } else {
            this.observableElement.addProperty(descriptor);
        }
        return this;
    }

    public ClientProcessDefinition done() {
        this.resolveDestinations();
        if (this.processDefinition.getInitial() == null) {
            throw new PvmException("no initial node");
        }
        return this.processDefinition;
    }

    public ProcessFactory version(int version) {
        this.processDefinition.setVersion(version);
        return this;
    }

    public ProcessFactory key(String key) {
        this.processDefinition.setKey(key);
        return this;
    }

    private void resolveDestinations() {
        if (this.destinationReferences != null) {
            for (DestinationReference destinationReference : this.destinationReferences) {
                destinationReference.resolve();
            }
        }
    }

    public class DestinationReference {
        private final TransitionImpl transition;
        private final String destinationName;

        public DestinationReference(TransitionImpl transition, String destinationName) {
            this.transition = transition;
            this.destinationName = destinationName;
        }

        public void resolve() {
            NodeImpl destination = (NodeImpl)ProcessFactory.this.processDefinition.findNode(this.destinationName);
            if (destination == null) {
                throw new PvmException("couldn't find destination node '" + this.destinationName + "' for transition " + this.transition);
            }
            destination.addIncomingTransition(this.transition);
            this.transition.setDestination(destination);
        }
    }
}

