/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import java.util.Date;
import java.util.List;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.SignalExecUtil;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.var.MessageVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAssociateMessage
implements Command<BpelExecution> {
    private static final long serialVersionUID = 6701148536558031859L;
    protected OperationKey operationKey;
    protected MessageVariable incomingMessage;
    protected MessageCarrier messageCarrier;
    protected boolean lock;
    protected Date parentInstanceStartDate;

    public AsyncAssociateMessage(OperationKey operationKey, MessageVariable incomingMessage, MessageCarrier messageCarrier, boolean lock, Date parentInstanceStartDate) {
        this.operationKey = operationKey;
        this.incomingMessage = incomingMessage;
        this.messageCarrier = messageCarrier;
        this.lock = lock;
        this.parentInstanceStartDate = parentInstanceStartDate;
    }

    @Override
    public BpelExecution execute(Environment environment) {
        ExecElementToSignal newExecElt;
        Repository repository = EnvTool.getRepository();
        BpelProcess activeBpelProcess = null;
        List<BpelProcess> bpelProcesses = this.lock ? repository.lockProcesses(this.operationKey.getProcessQName()) : repository.getProcesses(this.operationKey.getProcessQName());
        PendingMessage pendingMessage = Receiver.storeIncomingMessage(this.incomingMessage, this.messageCarrier, this.operationKey);
        for (BpelProcess bpelProcess : bpelProcesses) {
            ExecElementToSignal newExecElt2 = Receiver.associatePendingMessage(pendingMessage, bpelProcess, this.operationKey, this.parentInstanceStartDate);
            if (newExecElt2 != null) {
                SignalExecUtil.execute(environment, newExecElt2.getBpelExecution(), newExecElt2.getReceivingElement(), newExecElt2.getPendingMessage());
                return newExecElt2.getBpelExecution();
            }
            if (bpelProcess.isRetired()) continue;
            activeBpelProcess = bpelProcess;
        }
        if (activeBpelProcess != null && (newExecElt = Receiver.startNewInstance(pendingMessage, activeBpelProcess, this.operationKey, this.parentInstanceStartDate)) != null) {
            SignalExecUtil.execute(environment, newExecElt.getBpelExecution(), newExecElt.getReceivingElement(), newExecElt.getPendingMessage());
            return newExecElt.getBpelExecution();
        }
        Receiver.storePendingMessage(pendingMessage);
        return null;
    }
}

