/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.pvm.Execution;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.job.Job;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.services.itf.Repository;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbRepository
implements Repository {
    @Override
    public long getNextProcessCount() {
        ProcessDeploymentCounter processDeploymentCounter = this.getBpelPersistenceService().getProcessDeploymentCounter();
        if (processDeploymentCounter == null) {
            processDeploymentCounter = new ProcessDeploymentCounter();
            this.getBpelPersistenceService().save(processDeploymentCounter);
        }
        return processDeploymentCounter.getAndIncrementProcessCounter();
    }

    @Override
    public BpelProcess getActiveProcess(QName processQName) {
        return this.getBpelPersistenceService().findActiveBpelProcess(processQName);
    }

    @Override
    public BpelProcess getProcess(ProcessDefinitionUUID processUUID) {
        return this.getBpelPersistenceService().getBpelProcess(processUUID);
    }

    @Override
    public List<BpelProcess> getProcesses(QName processQName) {
        return this.getBpelPersistenceService().findBpelProcesses(processQName, false);
    }

    @Override
    public List<BpelProcess> getProcesses() {
        return this.getBpelPersistenceService().getBpelProcesses();
    }

    @Override
    public BpelProcess removeProcess(QName processQName) {
        BpelProcess process = this.getActiveProcess(processQName);
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
        }
        return process;
    }

    @Override
    public BpelProcess removeProcess(ProcessDefinitionUUID pduuid) {
        BpelProcess process = this.getBpelPersistenceService().getBpelProcess(pduuid);
        if (process != null) {
            this.getBpelPersistenceService().delete(process);
        }
        return process;
    }

    @Override
    public void storeProcess(BpelProcess process) {
        this.getBpelPersistenceService().save(process);
    }

    @Override
    public List<BpelProcess> lockProcesses(QName processQName) {
        return this.getBpelPersistenceService().findBpelProcesses(processQName, true);
    }

    @Override
    public BpelExecution getInstance(ProcessInstanceUUID processInstanceUUID) {
        return this.getBpelPersistenceService().getBpelInstance(processInstanceUUID);
    }

    @Override
    public List<BpelExecution> getInstances() {
        return this.getBpelPersistenceService().getBpelInstances();
    }

    @Override
    public List<BpelExecution> getInstances(QName processQName) {
        return this.getBpelPersistenceService().getBpelInstances(processQName);
    }

    @Override
    public List<BpelExecution> getInstances(ProcessDefinitionUUID processUUID) {
        return this.getBpelPersistenceService().getBpelInstances(processUUID);
    }

    @Override
    public void removeInstance(BpelExecution instance) {
        this.removeInstance(instance, false);
    }

    @Override
    public void storeExecution(Execution child) {
        this.getBpelPersistenceService().save(child);
    }

    @Override
    public void removeExecution(Execution child) {
        this.getBpelPersistenceService().delete(child);
    }

    @Override
    public void removeInstance(BpelExecution instance, boolean force) {
        if (force && instance != null && (instance.getProcessInstanceState().equals((Object)ActivityState.RUNNING) || instance.getProcessInstanceState().equals((Object)ActivityState.SUSPENDED))) {
            instance.exit();
        }
        if (instance != null) {
            this.getBpelPersistenceService().delete(instance.getProcessInstance());
        }
    }

    @Override
    public void storeInstance(BpelExecution instance) {
        this.getBpelPersistenceService().save(instance.getProcessInstance());
    }

    @Override
    public BpelExecution getUpdatedExecution(long executionId) {
        return this.getBpelPersistenceService().get(BpelExecution.class, executionId);
    }

    @Override
    public List<Job> findJobsWithException() {
        return this.getBpelPersistenceService().findJobsWithException();
    }

    @Override
    public JobImpl<?> getJob(long jobId) {
        return this.getBpelPersistenceService().get(JobImpl.class, jobId);
    }

    @Override
    public WaitingExecution.WaitingExecutionIterator getWaitingExecutions(ReceivingElement receivingElement, Map<QName, Document> csProperties) {
        return this.getBpelPersistenceService().getWaitingExecutions(receivingElement, csProperties);
    }

    @Override
    public WaitingExecution getFirstWaitingExecution(InboundMessageElement inboundMessageElement) {
        return this.getBpelPersistenceService().getFirstWaitingExecution(inboundMessageElement);
    }

    @Override
    public void storePendingMessage(PendingMessage pendingMessage) {
        this.getBpelPersistenceService().save(pendingMessage);
    }

    @Override
    public void removePendingMessage(PendingMessage pendingMessage) {
        this.getBpelPersistenceService().delete(pendingMessage);
    }

    @Override
    public Collection<PendingMessage> getPendingMessages(OperationKey operationKey) {
        return this.getBpelPersistenceService().getPendingMessages(operationKey);
    }

    private RuntimeDbSession getBpelPersistenceService() {
        return Environment.getCurrent().get(RuntimeDbSession.class);
    }
}

