/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services.impl;

import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEndpoint {
    private final QName processQName;
    private final Port port;
    private Map<String, Boolean> isOneWay = new HashMap<String, Boolean>();
    private Map<String, Boolean> locks = new HashMap<String, Boolean>();
    private final Map<ProcessDefinitionUUID, ProcessVersionEndpoint> versions = new HashMap<ProcessDefinitionUUID, ProcessVersionEndpoint>();

    public ProcessEndpoint(QName processQName, Port port) {
        this.processQName = processQName;
        this.port = port;
    }

    public boolean isLock(String operationName) {
        return this.locks.get(operationName);
    }

    public boolean isOneWay(String operationName) {
        return this.isOneWay.get(operationName);
    }

    public QName getProcessQName() {
        return this.processQName;
    }

    public void addProcessVersion(ProcessDefinitionUUID processDefinitionUUID, Map<String, Boolean> isOneWayMap, Map<String, Boolean> locksMap) {
        this.versions.put(processDefinitionUUID, new ProcessVersionEndpoint(processDefinitionUUID, isOneWayMap, locksMap));
        this.updateDatas();
    }

    public void removeProcessVersion(ProcessDefinitionUUID processDefinitionUUID) {
        this.versions.remove(processDefinitionUUID);
        this.updateDatas();
    }

    public boolean isUndeployed() {
        return this.versions.isEmpty();
    }

    private void updateDatas() {
        HashMap<String, Boolean> newOneWay = new HashMap<String, Boolean>();
        HashMap<String, Boolean> newLocks = new HashMap<String, Boolean>();
        for (ProcessVersionEndpoint version : this.versions.values()) {
            for (Map.Entry<String, Boolean> e : version.getIsOneWay().entrySet()) {
                newOneWay.put(e.getKey(), e.getValue());
            }
            for (Map.Entry<String, Boolean> e : version.getLocks().entrySet()) {
                if (newLocks.containsKey(e.getKey())) {
                    newLocks.put(e.getKey(), e.getValue() != false || (Boolean)newLocks.get(e.getKey()) != false);
                    continue;
                }
                newLocks.put(e.getKey(), e.getValue());
            }
        }
        this.isOneWay = newOneWay;
        this.locks = newLocks;
    }

    public Port getPort() {
        return this.port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessVersionEndpoint {
        private final ProcessDefinitionUUID processUUID;
        private final Map<String, Boolean> isOneWay;
        private final Map<String, Boolean> locks;

        public ProcessVersionEndpoint(ProcessDefinitionUUID processUUID, Map<String, Boolean> isOneWay, Map<String, Boolean> locks) {
            this.processUUID = processUUID;
            this.isOneWay = isOneWay;
            this.locks = locks;
        }

        public ProcessDefinitionUUID getProcessUUID() {
            return this.processUUID;
        }

        public Map<String, Boolean> getIsOneWay() {
            return this.isOneWay;
        }

        public Map<String, Boolean> getLocks() {
            return this.locks;
        }
    }
}

