/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.example.loanApproval;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.perf.RemotePerfTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LoanApprovalTest
extends RemotePerfTestCase {
    protected String getProcessName() {
        return "loanService";
    }

    protected String getProcessNamespace() {
        return "http://orchestra.ow2.org/loanApproval/loanService";
    }

    public void deploy() {
        this.deploy(LoanApprovalTest.class.getResource("approval/approval.bpel"), LoanApprovalTest.class.getResource("approval/approval.wsdl"));
        this.deploy(LoanApprovalTest.class.getResource("riskAssessment/riskAssessment.bpel"), LoanApprovalTest.class.getResource("riskAssessment/riskAssessment.wsdl"));
        this.deploy(LoanApprovalTest.class.getResource(this.getProcessName() + ".bpel"), LoanApprovalTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public void undeploy() {
        this.undeploy(new QName(this.getProcessNamespace(), this.getProcessName()));
        this.undeploy(new QName("http://orchestra.ow2.org/loanApproval/approval", "approval"));
        this.undeploy(new QName("http://orchestra.ow2.org/loanApproval/riskAssessment", "riskAssessment"));
    }

    public long launch() {
        long endTime = -1L;
        int amount = Misc.random((int)0, (int)60000);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", Integer.toString(amount)), (String)this.getDefaultEndpoint("loanServicePort"));
        endTime = System.currentTimeMillis();
        if (amount >= 30000) {
            this.assertResult(response, "no");
        } else {
            this.assertResult(response, "yes");
        }
        return endTime;
    }

    public void testLoanApproval() {
        try {
            this.deploy();
            String endpoint = this.getDefaultEndpoint("loanServicePort");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "9999"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "10000"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Hash", "50000"), (String)endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "30000"), (String)endpoint), "no");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Dupont", "20000"), (String)endpoint), "yes");
            this.assertResult(SOAPUtil.call((SOAPMessage)this.getRequest("firstName", "Martin", "10000"), (String)endpoint), "no");
            this.undeploy();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void assertResult(SOAPMessage response, String expected) {
        if (response != null) {
            SOAPBodyElement operationElement = null;
            try {
                operationElement = this.getSOAPBodyElement(response);
                Assert.assertNotNull((Object)operationElement);
                List elements = XmlUtil.elements((Element)operationElement);
                Assert.assertEquals((String)XmlUtil.toString((Node)operationElement), (int)1, (int)elements.size());
                Element partElement = (Element)elements.get(0);
                Assert.assertEquals((String)"accept", (String)partElement.getLocalName());
                NodeList texts = partElement.getChildNodes();
                Assert.assertEquals((int)1, (int)texts.getLength());
                Assert.assertTrue((boolean)(texts.item(0) instanceof Text));
                Assert.assertEquals((String)expected, (String)texts.item(0).getTextContent());
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
            catch (AssertionFailedError e) {
                System.err.println("AssertionFailed, operationElement = " + XmlUtil.toString((Node)operationElement));
                throw e;
            }
        } else {
            Assert.assertTrue((String)"No return available", (boolean)false);
        }
    }

    private SOAPMessage getRequest(String firstName, String name, String amount) {
        return SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/loanApproval/loanService", (String)("<loan:request xmlns:loan='http://orchestra.ow2.org/loanApproval/common'><firstName>" + firstName + "</firstName>" + "<name>" + name + "</name>" + "<amount>" + amount + "</amount>" + "</loan:request>"));
    }

    public String getAlias() {
        return "axis.loan";
    }
}

