/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.perf.correlation;

import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.novabpm.perf.PerfException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.perf.AbstractPerfTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Element;

public class SimpleCorrelationTest
extends AbstractPerfTestCase {
    public SimpleCorrelationTest() {
        super("http://example.com/simpleCorrelation", "simpleCorrelation");
    }

    public void deploy() {
        this.deploy(SimpleCorrelationTest.class.getResource(this.getProcessName() + ".bpel"), SimpleCorrelationTest.class.getResource(this.getProcessName() + ".wsdl"));
    }

    public long launch() throws PerfException {
        return this.launch(true);
    }

    public long launch(boolean finish) {
        final String auctionId = UUID.randomUUID().toString();
        final String shippingCosts1 = UUID.randomUUID().toString();
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)shippingCosts1));
        parts.put("auctionId", BpelXmlUtil.createElementWithContent((String)auctionId));
        final String shippingCosts2 = UUID.randomUUID().toString();
        HashMap<String, Element> parts2 = new HashMap<String, Element>();
        parts2.put("shippingCosts", BpelXmlUtil.createElementWithContent((String)shippingCosts2));
        parts2.put("auctionId", BpelXmlUtil.createElementWithContent((String)auctionId));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "create");
        if (finish) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long startTime = System.currentTimeMillis();
            BpelTestCase.CallResult callResult2 = this.call(parts2, portTypeQName, "submit");
            long endTime = System.currentTimeMillis();
            Assert.assertNotNull((Object)callResult2.getProcessInstanceUUID());
            this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
            CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
            commandService.execute((Command)new Command<Object>(){

                public Object execute(Environment environment) {
                    Assert.assertNotNull(callResult.getVariables());
                    Assert.assertEquals((int)1, (int)callResult.getVariables().size());
                    String expected1 = auctionId + "-" + shippingCosts1 + "-" + auctionId + "-" + shippingCosts2;
                    String expected2 = auctionId + "-" + shippingCosts2 + "-" + auctionId + "-" + shippingCosts1;
                    Object result = SimpleCorrelationTest.this.getVariableValue(callResult, "result");
                    if (!SimpleCorrelationTest.this.assertResult(result, expected1) && !SimpleCorrelationTest.this.assertResult(result, expected2)) {
                        Assert.assertTrue((String)("wrong correlation, expected was either " + expected1 + ", either " + expected2 + "and the result is " + result), (boolean)false);
                    }
                    Assert.assertTrue((boolean)true);
                    SimpleCorrelationTest.this.deleteInstance(callResult);
                    return null;
                }
            });
            return endTime - startTime;
        }
        return 0L;
    }

    private boolean assertResult(Object o, String expected) {
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((String)"result is not an instance of Element", (boolean)(o instanceof Element));
        Element result = (Element)o;
        boolean b = expected.equals(result.getTextContent());
        return b;
    }

    public void testSimpleCorrelation() {
        int i;
        int[] instances = new int[]{1, 10, 100, 1000, 10000};
        long[] durations = new long[instances.length];
        this.deploy();
        int total = 0;
        for (i = 0; i < instances.length; ++i) {
            int delta = instances[i] - total;
            durations[i] = this.timeCorrelationDuration(delta);
            total = instances[i];
        }
        this.deleteInstances(instances[instances.length - 1]);
        this.undeploy();
        for (i = 0; i < instances.length; ++i) {
            System.out.println(instances[i] + " instances finished in " + durations[i] + "ms.");
        }
    }

    private long timeCorrelationDuration(int instances) {
        for (int i = 0; i < instances; ++i) {
            this.launch(false);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.launch(true);
    }

    public String getAlias() {
        return "class.correlations";
    }
}

