/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.hibernate.regions;

import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.regions.EhcacheEntityRegion;
import net.sf.ehcache.hibernate.regions.EhcacheTransactionalDataRegion;
import net.sf.ehcache.hibernate.strategy.NonStrictReadWriteEhcacheCollectionRegionAccessStrategy;
import net.sf.ehcache.hibernate.strategy.ReadOnlyEhcacheCollectionRegionAccessStrategy;
import net.sf.ehcache.hibernate.strategy.ReadWriteEhcacheCollectionRegionAccessStrategy;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheCollectionRegion
extends EhcacheTransactionalDataRegion
implements CollectionRegion {
    private static final Logger LOG = LoggerFactory.getLogger(EhcacheEntityRegion.class);

    public EhcacheCollectionRegion(Ehcache underlyingCache, Settings settings, CacheDataDescription metadata, Properties properties) {
        super(underlyingCache, settings, metadata, properties);
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals(accessType)) {
            if (this.metadata.isMutable()) {
                LOG.warn("read-only cache configured for mutable entity [" + this.getName() + "]");
            }
            return new ReadOnlyEhcacheCollectionRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.READ_WRITE.equals(accessType)) {
            return new ReadWriteEhcacheCollectionRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.NONSTRICT_READ_WRITE.equals(accessType)) {
            return new NonStrictReadWriteEhcacheCollectionRegionAccessStrategy(this, this.settings);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            throw new CacheException("Transactional access is not supported by the Ehcache region factory.");
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

