/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.util.List;
import org.ow2.orchestra.facade.InstanceManagementAPI;
import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.jmx.commands.ExitInstanceCommand;
import org.ow2.orchestra.jmx.commands.FindJobsWithExceptionCommand;
import org.ow2.orchestra.jmx.commands.RemoveInstanceCommand;
import org.ow2.orchestra.jmx.commands.ResumeInstanceCommand;
import org.ow2.orchestra.jmx.commands.RetryJobCommand;
import org.ow2.orchestra.jmx.commands.SuspendInstanceCommand;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManagementAPIImpl
implements InstanceManagementAPI {
    private final EnvironmentFactory environmentFactory;

    public InstanceManagementAPIImpl(EnvironmentFactory environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    protected CommandService getCommandService() {
        return this.environmentFactory.get(CommandService.class);
    }

    @Override
    public void exit(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ExitInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void resume(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new ResumeInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public void suspend(ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException {
        InstanceNotFoundException infe = this.getCommandService().execute(new SuspendInstanceCommand(processInstanceUUID));
        if (infe != null) {
            throw infe;
        }
    }

    @Override
    public boolean remove(ProcessInstanceUUID processInstanceUUID) {
        return this.getCommandService().execute(new RemoveInstanceCommand(processInstanceUUID));
    }

    @Override
    public List<JobData> findJobsWithException() {
        return this.getCommandService().execute(new FindJobsWithExceptionCommand());
    }

    @Override
    public void retryJob(JobData jobData, int retries) throws JobNotFoundException {
        if (!this.getCommandService().execute(new RetryJobCommand(retries, jobData)).booleanValue()) {
            throw new JobNotFoundException(jobData);
        }
    }
}

