/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.element.Correlation;
import org.ow2.orchestra.definition.element.InboundMessageElement;
import org.ow2.orchestra.deployment.ProcessDeploymentCounter;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.RuntimeDbSession;
import org.ow2.orchestra.pvm.internal.hibernate.HibernatePvmDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.WaitingExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.ReceivingElement;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ReceivingElementUtil;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeDbSessionImpl
extends HibernatePvmDbSession
implements RuntimeDbSession {
    private static final Logger LOG = Logger.getLogger(RuntimeDbSessionImpl.class.getName());

    public RuntimeDbSessionImpl(Session session) {
        this.setSession(session);
        session.setFlushMode(FlushMode.COMMIT);
    }

    public BpelProcess findBpelProcess(QName processQName, boolean lock) {
        if (lock) {
            Query query = this.getSession().getNamedQuery("findLatestBpelProcessForLock");
            query.setString("qname", processQName.toString());
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE));
            query.setCacheable(false);
            BpelProcess.InstanceCreationLock res = (BpelProcess.InstanceCreationLock)query.uniqueResult();
            if (res == null) {
                return null;
            }
        }
        return this.findActiveBpelProcess(processQName);
    }

    @Override
    public BpelProcess findActiveBpelProcess(QName processQName) {
        Query query = this.getSession().getNamedQuery("findLatestBpelProcess");
        query.setString("namespace", processQName.getNamespaceURI());
        query.setString("name", processQName.getLocalPart());
        query.setCacheable(true);
        return (BpelProcess)query.uniqueResult();
    }

    @Override
    public List<BpelProcess> findBpelProcesses(QName processQName, boolean lock) {
        if (lock) {
            Query query = this.getSession().getNamedQuery("findBpelProcessesByQNameForLock");
            query.setString("qname", processQName.toString());
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE));
            query.setCacheable(false);
            List res = query.list();
            if (res == null || res.isEmpty()) {
                return null;
            }
        }
        return this.findBpelProcesses(processQName);
    }

    private List<BpelProcess> findBpelProcesses(QName processQName) {
        Query query = this.getSession().getNamedQuery("findBpelProcessesByQName");
        query.setString("namespace", processQName.getNamespaceURI());
        query.setString("name", processQName.getLocalPart());
        query.setCacheable(true);
        return query.list();
    }

    @Override
    public BpelProcess findBpelProcess(ProcessDefinitionUUID pduuid, boolean lock) {
        if (lock) {
            Query query = this.getSession().getNamedQuery("findBpelProcessForLock");
            query.setString("uuid", pduuid.toString());
            query.setLockOptions(new LockOptions(LockMode.PESSIMISTIC_WRITE));
            query.setCacheable(false);
            BpelProcess.InstanceCreationLock res = (BpelProcess.InstanceCreationLock)query.uniqueResult();
            if (res == null) {
                return null;
            }
        }
        return this.getBpelProcess(pduuid);
    }

    @Override
    public BpelProcess getBpelProcess(ProcessDefinitionUUID pduuid) {
        Query query = this.getSession().getNamedQuery("getBpelProcessByUUID");
        query.setString("uuid", pduuid.toString());
        query.setCacheable(true);
        BpelProcess processDefinition = (BpelProcess)query.uniqueResult();
        return processDefinition;
    }

    @Override
    public List<BpelProcess> getBpelProcesses() {
        Query query = this.getSession().getNamedQuery("getBpelProcesses");
        query.setCacheable(true);
        return query.list();
    }

    private List<Set<QName>> getPermutations(Set<QName> firstQNames, Set<Correlation> optionalCorrelations) {
        if (optionalCorrelations.isEmpty()) {
            return Arrays.asList(firstQNames);
        }
        Correlation firstAvailable = optionalCorrelations.iterator().next();
        optionalCorrelations.remove(firstAvailable);
        ArrayList<Set<QName>> result = new ArrayList<Set<QName>>();
        HashSet<QName> res1 = new HashSet<QName>(firstQNames);
        res1.addAll(firstAvailable.getCorrelationSet().getProperties().keySet());
        result.addAll(this.getPermutations(res1, optionalCorrelations));
        HashSet<QName> res2 = new HashSet<QName>(firstQNames);
        result.addAll(this.getPermutations(res2, optionalCorrelations));
        return result;
    }

    @Override
    public WaitingExecution.WaitingExecutionIterator getWaitingExecutions(ReceivingElement receivingElement, Map<QName, Document> csProperties) {
        HashSet<QName> requiredProperties = new HashSet<QName>();
        HashSet<Correlation> optionalCorrelations = new HashSet<Correlation>();
        for (Correlation correlation : receivingElement.getCorrelations()) {
            if (correlation.getInitiate().equals((Object)Correlation.Initiate.no)) {
                requiredProperties.addAll(correlation.getCorrelationSet().getProperties().keySet());
                continue;
            }
            if (!correlation.getInitiate().equals((Object)Correlation.Initiate.join)) continue;
            optionalCorrelations.add(correlation);
        }
        List<Set<QName>> propertiesValues = this.getPermutations(requiredProperties, optionalCorrelations);
        Misc.log(Level.INFO, "getWaitingExecutions:  %s possible correlations found.", propertiesValues.size());
        for (Set<QName> propQNames : propertiesValues) {
            Misc.log(Level.INFO, "getWaitingExecutions:  trying to match %s correlation properties.", propQNames.size());
            HashMap<QName, Document> csProps = new HashMap<QName, Document>(csProperties);
            csProps.keySet().retainAll(propQNames);
            int correlationKey = ReceivingElementUtil.getCorrelationPropertiesKey(csProps);
            Query query = this.getSession().getNamedQuery("getWaitingExecutionsByCorrelationKey");
            query.setParameter("activity", (Object)receivingElement.getInboundMessageElement());
            query.setInteger("correlationKey", correlationKey);
            ScrollableResults waitingExecutions = query.scroll();
            if (waitingExecutions.first()) {
                waitingExecutions.beforeFirst();
                return new WaitingExecutionIteratorImpl(waitingExecutions, this.getSession());
            }
            waitingExecutions.close();
        }
        return new WaitingExecutionIteratorImpl(null, this.getSession());
    }

    @Override
    public WaitingExecution getFirstWaitingExecution(InboundMessageElement inboundMessageElement) {
        Query query = this.getSession().getNamedQuery("getWaitingExecutions");
        query.setParameter("activity", (Object)inboundMessageElement);
        query.setMaxResults(1);
        Serializable id = (Serializable)query.uniqueResult();
        if (id != null) {
            return this.get(WaitingExecution.class, id);
        }
        return null;
    }

    @Override
    public Collection<PendingMessage> getPendingMessages(OperationKey operationKey) {
        Query query = this.getSession().getNamedQuery("getPendingMessages");
        query.setString("operationKey", operationKey.toString());
        return query.list();
    }

    @Override
    public List<BpelExecution> getBpelInstances() {
        Query query = this.getSession().getNamedQuery("getBpelInstances");
        return query.list();
    }

    @Override
    public BpelExecution getBpelInstance(ProcessInstanceUUID processInstanceUUID) {
        Query query = this.getSession().getNamedQuery("getBpelInstance");
        query.setString("processInstanceUUID", processInstanceUUID.toString());
        BpelExecution bpelExecution = (BpelExecution)query.uniqueResult();
        return bpelExecution;
    }

    @Override
    public List<BpelExecution> getBpelInstances(QName processQName) {
        Query query = this.getSession().getNamedQuery("getBpelInstancesOfProcess");
        query.setString("namespace", processQName.getNamespaceURI());
        query.setString("name", processQName.getLocalPart());
        return query.list();
    }

    @Override
    public List<BpelExecution> getBpelInstances(ProcessDefinitionUUID pduuid) {
        Query query = this.getSession().getNamedQuery("getBpelInstancesOfProcessByUUID");
        query.setString("uuid", pduuid.toString());
        return query.list();
    }

    @Override
    public ProcessDeploymentCounter getProcessDeploymentCounter() {
        return (ProcessDeploymentCounter)this.getSession().createCriteria(ProcessDeploymentCounter.class).uniqueResult();
    }

    @Override
    public void clearProcessCache() {
        this.getSession().getSessionFactory().getCache().evictDefaultQueryRegion();
        this.getSession().getSessionFactory().getCache().evictEntityRegion(BpelProcess.class);
        Misc.fastDynamicLog(LOG, Level.INFO, "BpelProcess Cache cleared", new Object[0]);
    }

    private static class WaitingExecutionIteratorImpl
    implements WaitingExecution.WaitingExecutionIterator {
        private final ScrollableResults results;
        private final Session session;
        private WaitingExecution current = null;

        public WaitingExecutionIteratorImpl(ScrollableResults results, Session session) {
            this.results = results;
            this.session = session;
        }

        public WaitingExecution next() {
            if (this.results == null) {
                return null;
            }
            if (this.current != null) {
                this.session.evict(this.current);
            }
            if (this.results.next()) {
                Serializable id = (Serializable)this.results.get(0);
                this.current = (WaitingExecution)this.session.get(WaitingExecution.class, id);
                if (this.current == null) {
                    Misc.log(Level.INFO, "WaitingExecution %s not found, skipping.", id);
                    return this.next();
                }
                return this.current;
            }
            this.results.close();
            return null;
        }
    }
}

