/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.env;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.ow2.orchestra.pvm.env.Context;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.env.PvmEnvironment;
import org.ow2.orchestra.pvm.internal.env.PvmEnvironmentFactoryParser;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.stream.FileStreamSource;
import org.ow2.orchestra.pvm.internal.stream.InputStreamSource;
import org.ow2.orchestra.pvm.internal.stream.ResourceStreamSource;
import org.ow2.orchestra.pvm.internal.stream.StreamSource;
import org.ow2.orchestra.pvm.internal.stream.StringStreamSource;
import org.ow2.orchestra.pvm.internal.stream.UrlStreamSource;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvmEnvironmentFactory
extends EnvironmentFactory
implements Context {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(PvmEnvironmentFactory.class.getName());
    protected static PvmEnvironmentFactoryParser pvmEnvironmentFactoryParser = new PvmEnvironmentFactoryParser();
    protected WireContext environmentFactoryCtxWireContext = null;
    protected WireDefinition environmentCtxWireDefinition = null;

    public PvmEnvironmentFactory() {
    }

    public PvmEnvironmentFactory(String resource) {
        this(resource, null);
    }

    public PvmEnvironmentFactory(String resource, ClassLoader classLoader) {
        this(new ResourceStreamSource(resource, classLoader));
    }

    public PvmEnvironmentFactory(File file) {
        this(new FileStreamSource(file));
    }

    public PvmEnvironmentFactory(URL url) {
        this(new UrlStreamSource(url));
    }

    public PvmEnvironmentFactory(InputStream inputStream) {
        this(new InputStreamSource(inputStream));
    }

    public static PvmEnvironmentFactory parseXmlString(String xmlString) {
        return new PvmEnvironmentFactory(new StringStreamSource(xmlString));
    }

    PvmEnvironmentFactory(StreamSource streamSource) {
        PvmEnvironmentFactoryParser.getInstance().createParse().setDocumentObject(this).setStreamSource(streamSource).execute().checkProblems("pvm environment configuration " + streamSource);
    }

    @Override
    public Environment openEnvironment() {
        PvmEnvironment environment = new PvmEnvironment(this);
        LOG.debug("opening " + environment);
        ClassLoader classLoader = this.environmentFactoryCtxWireContext.getClassLoader();
        if (classLoader != null) {
            environment.setClassLoader(classLoader);
        }
        environment.addContext(this.environmentFactoryCtxWireContext);
        WireContext environmentContext = new WireContext(this.environmentCtxWireDefinition, "environment", environment, true);
        environment.addContext(environmentContext);
        try {
            environmentContext.create();
        }
        catch (RuntimeException e) {
            Environment.popEnvironment();
            throw e;
        }
        return environment;
    }

    @Override
    public void close() {
        this.environmentFactoryCtxWireContext.fire("close", null);
    }

    @Override
    public Object get(String key) {
        return this.environmentFactoryCtxWireContext.get(key);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.environmentFactoryCtxWireContext.get(type);
    }

    @Override
    public String getName() {
        return this.environmentFactoryCtxWireContext.getName();
    }

    @Override
    public boolean has(String key) {
        return this.environmentFactoryCtxWireContext.has(key);
    }

    @Override
    public Set<String> keys() {
        return this.environmentFactoryCtxWireContext.keys();
    }

    @Override
    public Object set(String key, Object value) {
        return this.environmentFactoryCtxWireContext.set(key, value);
    }

    public void setEnvironmentCtxWireDefinition(WireDefinition blockWireDefinition) {
        this.environmentCtxWireDefinition = blockWireDefinition;
    }

    public WireContext getEnvironmentFactoryCtxWireContext() {
        return this.environmentFactoryCtxWireContext;
    }

    public void setEnvironmentFactoryCtxWireContext(WireContext applicationWireContext) {
        this.environmentFactoryCtxWireContext = applicationWireContext;
    }

    public WireDefinition getEnvironmentCtxWireDefinition() {
        return this.environmentCtxWireDefinition;
    }
}

