/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.svc;

import java.util.List;
import org.ow2.orchestra.pvm.Deployment;
import org.ow2.orchestra.pvm.ProcessDefinition;
import org.ow2.orchestra.pvm.ProcessService;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.cmd.DeployCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindLatestProcessDefinitionCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionNamesCmd;
import org.ow2.orchestra.pvm.internal.cmd.FindProcessDefinitionsCmd;
import org.ow2.orchestra.pvm.model.OpenProcessDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessService
implements ProcessService {
    protected CommandService commandService;

    public ProcessDefinition deploy(OpenProcessDefinition processDefinition) {
        Deployment deployment = new Deployment(processDefinition);
        return this.commandService.execute(new DeployCmd(deployment));
    }

    @Override
    public ProcessDefinition deploy(Deployment deployment) {
        return this.commandService.execute(new DeployCmd(deployment));
    }

    @Override
    public ProcessDefinition findLatestProcessDefinition(String processDefinitionName) {
        return this.commandService.execute(new FindLatestProcessDefinitionCmd(processDefinitionName));
    }

    @Override
    public ProcessDefinition findProcessDefinition(String processDefinitionName, int version) {
        return this.commandService.execute(new FindProcessDefinitionCmd(processDefinitionName, version));
    }

    @Override
    public List<String> findProcessDefinitionNames() {
        return this.commandService.execute(new FindProcessDefinitionNamesCmd());
    }

    @Override
    public List<ProcessDefinition> findProcessDefinitions(String processDefinitionName) {
        return this.commandService.execute(new FindProcessDefinitionsCmd(processDefinitionName));
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

