/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.type;

import java.io.Serializable;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.type.Converter;
import org.ow2.orchestra.pvm.internal.type.Type;

public abstract class Variable
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long dbid = -1L;
    protected int dbversion = 0;
    protected String key = null;
    protected Converter converter = null;
    protected String queryText = null;
    protected ExecutionImpl processInstance;

    public abstract boolean isStorable(Object var1);

    protected abstract Object getObject();

    protected abstract void setObject(Object var1);

    public boolean supports(Object value) {
        if (this.converter != null) {
            return this.converter.supports(value);
        }
        return this.isStorable(value);
    }

    public void setValue(Object value) {
        if (this.converter != null) {
            if (!this.converter.supports(value)) {
                throw new PvmException("the converter '" + this.converter.getClass().getName() + "' in variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
            }
            value = this.converter.convert(value);
        }
        if (value != null && !this.isStorable(value)) {
            throw new PvmException("variable instance '" + this.getClass().getName() + "' does not support values of type '" + value.getClass().getName() + "'.  to change the type of a variable, you have to delete it first");
        }
        this.setObject(value);
    }

    public Object getValue() {
        Object value = this.getObject();
        if (value != null && this.converter != null) {
            value = this.converter.revert(value);
        }
        return value;
    }

    public String toString() {
        return "${" + this.key + "}";
    }

    public Type getType() {
        Type type = new Type();
        type.setConverter(this.converter);
        type.setVariableClass(this.getClass());
        return type;
    }

    public String getKey() {
        return this.key;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionImpl processInstance) {
        this.processInstance = processInstance;
    }
}

