/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.wire.operation;

import java.lang.reflect.Field;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.pvm.internal.wire.Descriptor;
import org.ow2.orchestra.pvm.internal.wire.WireContext;
import org.ow2.orchestra.pvm.internal.wire.WireException;
import org.ow2.orchestra.pvm.internal.wire.operation.AbstractOperation;

public class FieldOperation
extends AbstractOperation {
    private static final long serialVersionUID = 1L;
    private String fieldName = null;
    private Descriptor descriptor = null;
    private transient Field field = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Object target, WireContext wireContext) {
        if (target != null) {
            FieldOperation fieldOperation = this;
            synchronized (fieldOperation) {
                if (this.field == null) {
                    Class<?> clazz = target.getClass();
                    this.field = ReflectUtil.getField(clazz, this.fieldName);
                }
            }
            Object value = wireContext.create(this.descriptor, true);
            try {
                ReflectUtil.set(this.field, target, value);
            }
            catch (Exception e) {
                throw new WireException("couldn't set " + this.fieldName + " to " + value, e);
            }
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor valueDescriptor) {
        this.descriptor = valueDescriptor;
    }
}

