/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.runtime;

import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.IAbstractActivity;
import org.ow2.orchestra.facade.data.runtime.BpelFaultData;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ScopeState;
import org.ow2.orchestra.pvm.internal.model.ExceptionHandlerImpl;
import org.ow2.orchestra.pvm.internal.model.ExecutionImpl;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.pvm.internal.model.ProcessElementImpl;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraFaultHandler
extends ExceptionHandlerImpl {
    private static final long serialVersionUID = 6330814889501735922L;
    private static Logger log = Logger.getLogger(OrchestraFaultHandler.class.getName());

    @Override
    public boolean matches(Class<?> exceptionClass) {
        return BpelFaultException.class.isAssignableFrom(exceptionClass);
    }

    @Override
    protected void executeHandler(ExecutionImpl execution, Exception exception, ProcessElementImpl processElementImpl) {
        BpelExecution scopeBpelExecution;
        NodeImpl scope = (NodeImpl)processElementImpl;
        BpelExecution bpelExecution = (BpelExecution)execution;
        BpelFaultException bpelFault = (BpelFaultException)exception;
        EnvTool.getRecorder().recordExceptionOccured(new BpelFaultData(bpelFault, bpelExecution.getActivityInstanceUUID()));
        for (scopeBpelExecution = bpelExecution; scopeBpelExecution != null && scopeBpelExecution.getNode() != scope; scopeBpelExecution = scopeBpelExecution.getParent()) {
        }
        if (scopeBpelExecution == null || scopeBpelExecution.getNode() != scope) {
            Misc.unreachableStatement("Cannot find the scope BpelExecution for scope " + scope);
            return;
        }
        ScopeRuntime scopeRuntime = bpelExecution.getScopeRuntimeWithScope((IAbstractActivity)scope.getBehaviour());
        log.finest("Handling exception " + exception + " in BpelExecution " + bpelExecution + ": scopeRuntime state is " + (Object)((Object)scopeRuntime.getState()) + ", scopeBpelExecution is " + scopeBpelExecution);
        if (ScopeState.RUNNING.equals((Object)scopeRuntime.getState())) {
            scopeRuntime.setLastException(bpelFault.fullCopy());
            scopeRuntime.setState(ScopeState.HANDLING_FAULT, bpelExecution);
            scopeBpelExecution.terminate();
        } else if (ScopeState.TERMINATING.equals((Object)scopeRuntime.getState())) {
            scopeRuntime.setState(ScopeState.COMPLETED_UNSUCCESSFUL, bpelExecution);
            scopeBpelExecution.exit();
            if (scopeBpelExecution.getParent() != null) {
                log.finest("Terminating parent " + scopeBpelExecution.getParent());
                scopeBpelExecution.getParent().terminate();
            }
        } else {
            if (ScopeState.HANDLING_FAULT.equals((Object)scopeRuntime.getState())) {
                scopeRuntime.setState(ScopeState.RETHROWING_FAULT, bpelExecution);
            }
            ExceptionHandlerImpl.rethrow(exception, "Rethrown by BpelExecution " + bpelExecution);
        }
    }
}

