/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanInvocationHandler
implements InvocationHandler {
    public static final int CONNECTION_TIMEOUT = 60000;
    private final ObjectName mbeanObjectName;
    private final JMXServiceURL url;
    private JMXConnector jmxc;

    public MBeanInvocationHandler(String jmxServiceUrl, String jmxObjectName) throws MalformedURLException, MalformedObjectNameException {
        this.url = new JMXServiceURL(jmxServiceUrl);
        this.mbeanObjectName = ObjectName.getInstance(jmxObjectName);
    }

    public synchronized JMXConnector getJmxc() throws IOException {
        if (this.jmxc == null) {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("jmx.remote.x.client.connection.check.period", 0);
            this.jmxc = JMXConnectorFactory.connect(this.url, params);
        }
        return this.jmxc;
    }

    public synchronized void closeJmxc() throws IOException {
        if (this.jmxc != null) {
            JMXConnector connector = this.jmxc;
            this.jmxc = null;
            connector.close();
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String[] signature;
        String[] stringArray = signature = args == null ? null : new String[args.length];
        if (args != null) {
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = types[i].getName();
            }
        }
        try {
            return this.getJmxc().getMBeanServerConnection().invoke(this.mbeanObjectName, method.getName(), args, signature);
        }
        catch (IOException e) {
            this.closeJmxc();
            throw e;
        }
        catch (RuntimeMBeanException e) {
            throw e.getTargetException();
        }
    }
}

