/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.definition.activity;

import java.util.Map;
import org.ow2.orchestra.definition.activity.AbstractActivity;
import org.ow2.orchestra.definition.activity.IActivityWithSingleChild;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.pvm.activity.ActivityExecution;
import org.ow2.orchestra.pvm.internal.model.NodeImpl;
import org.ow2.orchestra.runtime.BpelExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityWithSingleChild
extends AbstractActivity
implements IActivityWithSingleChild {
    private static final long serialVersionUID = 5280723485494800792L;
    protected NodeImpl child;

    protected ActivityWithSingleChild(NodeImpl child, ActivityDefinitionUUID uuid, String name) {
        this.child = child;
        this.setUuid(uuid);
        this.setName(name);
    }

    protected ActivityWithSingleChild() {
    }

    @Override
    public final void execute(ActivityExecution execution) throws Exception {
        BpelExecution bpelExecution = (BpelExecution)execution;
        this.beforeRunning(bpelExecution);
        this.executeActivity(bpelExecution);
    }

    public void executeActivity(BpelExecution bpelExecution) {
        bpelExecution.createExecution().execute(this.child);
    }

    @Override
    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        if (signal == null) {
            execution.end("ended");
            BpelExecution parentExecution = execution.getParent();
            parentExecution.removeExecution(execution);
            parentExecution.signal("finished");
        } else if (signal.equals("finished")) {
            this.afterRunned(execution);
            this.signal(execution);
        }
    }

    protected abstract void signal(BpelExecution var1);
}

