/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmx;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderInterceptor
implements InvocationHandler {
    private final Object api;
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public ClassLoaderInterceptor(Object api) {
        this.api = api;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.loader);
            Object object = method.invoke(this.api, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

