/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.AbstractJobExecutor;
import org.ow2.orchestra.pvm.internal.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;
import org.ow2.orchestra.pvm.internal.svc.RetryInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExceptionHandler
implements Command<Object> {
    private static final Log LOG = Log.getLog(JobExceptionHandler.class.getName());
    private static final long serialVersionUID = 1L;
    protected final long jobDbid;
    protected final JobImpl<?> failedJob;
    protected final Throwable exception;

    public JobExceptionHandler(long jobDbid, Throwable exception) {
        this.jobDbid = jobDbid;
        this.exception = exception;
        this.failedJob = null;
    }

    public JobExceptionHandler(JobImpl<?> job, Throwable exception) {
        this.jobDbid = job.getDbid();
        this.failedJob = job;
        this.exception = exception;
    }

    @Override
    public Object execute(Environment environment) {
        LOG.debug("handling jobImpl " + this.jobDbid + " exception: " + this.exception.getMessage());
        JobImpl job = this.failedJob;
        if (job == null) {
            JobDbSession session = environment.get(JobDbSession.class);
            if (session == null) {
                throw new PvmException("no job-session configured to handle job");
            }
            job = session.get(JobImpl.class, this.jobDbid);
        }
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (job != null) {
            int decrementedRetries = job.getRetries() - 1;
            LOG.debug("decrementing retries to " + decrementedRetries + " for " + job);
            job.setRetries(decrementedRetries);
            job.setException(sw.toString());
            LOG.debug("unlocking " + job);
            job.setLockOwner(null);
            job.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (decrementedRetries == 0) {
                LOG.error("All execution of job " + job + " failed." + "Last exception was " + job.getException());
                DeadJobHandler deadJobHandler = jobExecutor.getDeadJobHandler();
                if (deadJobHandler != null) {
                    deadJobHandler.handleDeadJob(job);
                }
            } else {
                CommandService commandService;
                long delay = 50L;
                int delayFactor = 2;
                if (jobExecutor instanceof AbstractJobExecutor && (commandService = ((AbstractJobExecutor)jobExecutor).getCommandExecutor()) instanceof RetryInterceptor) {
                    delay = ((RetryInterceptor)commandService).getDelay();
                    delayFactor = ((RetryInterceptor)commandService).getDelayFactor();
                }
                long attemptFactor = job.getDelay() * (long)(1 + RetryInterceptor.getRandom().nextInt(delayFactor - 1));
                job.setDelay(attemptFactor);
                job.setDueDate(new Date(System.currentTimeMillis() + delay * attemptFactor));
                Transaction transaction = environment.get(Transaction.class);
                if (transaction != null && jobExecutor != null) {
                    LOG.trace("registering job executor notifier with " + transaction);
                    transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
                }
            }
        }
        return null;
    }
}

