/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.locator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiLocator {
    private static Map<String, List<Callable<Class>>> factories;

    public static synchronized void unregister(String id, Callable<Class> factory) {
        List<Callable<Class>> l;
        if (factories != null && (l = factories.get(id)) != null) {
            l.remove(factory);
        }
    }

    public static synchronized void register(String id, Callable<Class> factory) {
        List<Callable<Class>> l;
        if (factories == null) {
            factories = new HashMap<String, List<Callable<Class>>>();
        }
        if ((l = factories.get(id)) == null) {
            l = new ArrayList<Callable<Class>>();
            factories.put(id, l);
        }
        l.add(factory);
    }

    public static synchronized Class locate(String factoryId) {
        List<Callable<Class>> l;
        if (factories != null && (l = factories.get(factoryId)) != null && !l.isEmpty()) {
            Callable<Class> c = l.get(0);
            try {
                return c.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

