/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.deployment;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.DeploymentException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.parsing.BpelParser;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.PendingMessage;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.ResultIterator;
import org.ow2.orchestra.services.handlers.UndeployedProcessHandler;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.Namespaces;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer {
    private BpelParser bpelParser = new BpelParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessFullDefinition deploy(Deployment bpelDeployment, Environment environment) {
        Misc.checkArgsNotNull(bpelDeployment, environment);
        Misc.log(Level.INFO, "Deploying BPEL deployment %s", bpelDeployment);
        InputSource bpel = bpelDeployment.getBpel();
        if (bpel == null) {
            throw new OrchestraRuntimeException("Unable to open BPEL Stream");
        }
        Parse parse = this.bpelParser.createParse();
        WsdlDefinitions wsdlDefinitions = bpelDeployment.getWsdlDefinitions();
        parse.pushObject(wsdlDefinitions);
        Namespaces namespaces = new Namespaces(parse);
        parse.pushObject(namespaces);
        ProcessFullDefinition processDefinition = null;
        ProcessResourcesRepository resourcesRepository = bpelDeployment.getResourcesRepository();
        parse.pushObject(resourcesRepository);
        WsdlsInfos wsdlInfos = new WsdlsInfos();
        parse.pushObject(wsdlInfos);
        BpelProcess bpelProcess = null;
        Repository repository = environment.get(Repository.class);
        DefinitionKeeper definitionKeeper = new DefinitionKeeper(repository.getNextProcessCount());
        parse.pushObject(definitionKeeper);
        try {
            bpelProcess = (BpelProcess)parse.setInputSource(bpel).execute().getDocumentObject();
        }
        finally {
            parse.popObject();
            parse.popObject();
            parse.popObject();
            parse.popObject();
            parse.popObject();
        }
        if (!parse.hasProblems()) {
            if (bpelProcess == null) {
                throw new OrchestraRuntimeException("Bpel Process null");
            }
            bpelProcess.staticAnalysisCheck(parse);
        }
        parse.checkProblems("bpel file");
        QName processQName = bpelProcess.getQName();
        List<BpelProcess> oldBpelProcesses = repository.getProcesses(processQName);
        int maxVersion = 0;
        for (BpelProcess oldBpelProcess : oldBpelProcesses) {
            oldBpelProcess.setRetired(true);
            if (oldBpelProcess.getVersion() <= maxVersion) continue;
            maxVersion = oldBpelProcess.getVersion();
        }
        bpelProcess.setVersion(maxVersion + 1);
        repository.storeProcess(bpelProcess);
        processDefinition = definitionKeeper.getProcessFullDefinition();
        processDefinition.setVersion(bpelProcess.getVersion());
        EnvTool.getRecorder().recordProcessDeployed(processDefinition);
        Misc.log(Level.INFO, "BPEL process %s deployed.", processQName);
        return processDefinition;
    }

    public void undeploy(QName processQName, Environment environment) {
        Repository repository = environment.get(Repository.class);
        BpelProcess bpelProcess = repository.getActiveProcess(processQName);
        this.undeploy(bpelProcess.getUUID(), environment);
        Misc.log(Level.INFO, "BPEL process %s undeployed.", processQName);
    }

    public void undeploy(ProcessDefinitionUUID pduuid, Environment environment) {
        Repository repository = environment.get(Repository.class);
        BpelProcess bpelProcess = repository.removeProcess(pduuid);
        if (bpelProcess == null) {
            throw new DeploymentException("Problem during undeployment : process " + pduuid + " not found");
        }
        List<BpelExecution> runningInstances = repository.getInstances(pduuid);
        if (runningInstances != null && !runningInstances.isEmpty()) {
            throw new DeploymentException("Problem during undeployment: some instances  of process " + pduuid + " are still running");
        }
        List<BpelProcess> processVersions = repository.getProcesses(bpelProcess.getQName());
        processVersions.remove(bpelProcess);
        if (!processVersions.isEmpty() && !bpelProcess.isRetired()) {
            BpelProcess highestProcessVersion = null;
            for (BpelProcess otherProcessVersion : processVersions) {
                if (highestProcessVersion != null && highestProcessVersion.getVersion() >= otherProcessVersion.getVersion()) continue;
                highestProcessVersion = otherProcessVersion;
            }
            if (highestProcessVersion != null) {
                highestProcessVersion.setRetired(false);
            }
        }
        this.removeUndeployedProcessPendingMessages(environment, bpelProcess, processVersions);
        EnvTool.getRecorder().recordProcessUndeployed(bpelProcess.getUUID());
        ProcessFullDefinition processDefinition = EnvTool.getQuerier().getProcessDefinition(bpelProcess.getUUID());
        UndeployedProcessHandler handler = EnvTool.get(UndeployedProcessHandler.class, "undeployed-process-handler");
        handler.handleUndeployedProcess(processDefinition);
        Misc.log(Level.INFO, "BPEL process %s undeployed.", pduuid);
    }

    private void removeUndeployedProcessPendingMessages(Environment environment, BpelProcess bpelProcess, List<BpelProcess> processVersions) {
        Publisher publisher = environment.get(Publisher.class);
        Set<OperationKey> processOperationKeys = publisher.getServiceOperationKeys(bpelProcess, environment);
        for (BpelProcess otherVersion : processVersions) {
            Set<OperationKey> otherVersionOpKeys = publisher.getServiceOperationKeys(otherVersion, environment);
            processOperationKeys.removeAll(otherVersionOpKeys);
        }
        for (OperationKey opKey : processOperationKeys) {
            ResultIterator<PendingMessage> pendingMessages = EnvTool.getRepository().getPendingMessages(opKey);
            PendingMessage pendingMessage = pendingMessages.next(false);
            while (pendingMessage != null) {
                Receiver.deletePendingMessage(pendingMessage);
                pendingMessage = pendingMessages.next(false);
            }
        }
    }
}

