/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.persistence.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.full.ActivityFullDefinition;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.persistence.QuerierDbSession;
import org.ow2.orchestra.services.Querier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDbQuerier
implements Querier {
    private final QuerierDbSession dbSession;
    private final Map<ProcessInstanceUUID, ProcessFullInstance> processFullInstanceByProcessInstanceUUIDMap;
    private final Map<ActivityInstanceUUID, ActivityFullInstance> activityFullInstanceByActivityInstanceUUIDMap;

    public AbstractDbQuerier(QuerierDbSession dbSession) {
        this.dbSession = dbSession;
        this.processFullInstanceByProcessInstanceUUIDMap = new HashMap<ProcessInstanceUUID, ProcessFullInstance>();
        this.activityFullInstanceByActivityInstanceUUIDMap = new HashMap<ActivityInstanceUUID, ActivityFullInstance>();
    }

    protected QuerierDbSession getQuerierDbSession() {
        return this.dbSession;
    }

    @Override
    public ActivityFullInstance getActivityInstance(ActivityInstanceUUID activityInstanceUUID) {
        ActivityFullInstance activityFullInstance = this.activityFullInstanceByActivityInstanceUUIDMap.get(activityInstanceUUID);
        if (activityFullInstance == null && (activityFullInstance = this.getQuerierDbSession().getActivityInstance(activityInstanceUUID)) != null) {
            this.activityFullInstanceByActivityInstanceUUIDMap.put(activityFullInstance.getUUID(), activityFullInstance);
        }
        return activityFullInstance;
    }

    public void addProcessInstance(ProcessFullInstance processFullInstance) {
        this.processFullInstanceByProcessInstanceUUIDMap.put(processFullInstance.getUUID(), processFullInstance);
        this.activityFullInstanceByActivityInstanceUUIDMap.put(processFullInstance.getUUID(), processFullInstance);
    }

    public void addActivityInstance(ActivityFullInstance activityFullInstance) {
        this.activityFullInstanceByActivityInstanceUUIDMap.put(activityFullInstance.getUUID(), activityFullInstance);
    }

    @Override
    public ProcessFullInstance getProcessInstance(ProcessInstanceUUID processInstanceUUID) {
        ProcessFullInstance processFullInstance = this.processFullInstanceByProcessInstanceUUIDMap.get(processInstanceUUID);
        if (processFullInstance == null) {
            processFullInstance = this.getQuerierDbSession().getProcessInstance(processInstanceUUID);
        }
        return processFullInstance;
    }

    public void removeProcessInstance(ProcessFullInstance processFullInstance) {
        this.processFullInstanceByProcessInstanceUUIDMap.remove(processFullInstance.getProcessInstanceUUID());
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID processUUID) {
        return this.getQuerierDbSession().findActivityInstance(processUUID);
    }

    @Override
    public Set<ActivityFullInstance> findActivityInstances(ProcessInstanceUUID processDefinitionUUID, ActivityState activityState) {
        return this.getQuerierDbSession().findActivityInstance(processDefinitionUUID, activityState);
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances() {
        return this.getQuerierDbSession().findProcessInstance();
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getQuerierDbSession().findProcessInstance(processDefinitionUUID);
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ProcessDefinitionUUID processDefinitionUUID, ActivityState processInstanceState) {
        return this.getQuerierDbSession().findProcessInstance(processDefinitionUUID, processInstanceState);
    }

    @Override
    public Set<ProcessFullInstance> findProcessInstances(ActivityState processInstanceState) {
        return this.getQuerierDbSession().findProcessInstance(processInstanceState);
    }

    @Override
    public ActivityFullDefinition getActivityDefinition(ActivityDefinitionUUID activityDefinitionUUID) {
        return this.getQuerierDbSession().getActivityDefinition(activityDefinitionUUID);
    }

    @Override
    public Set<ActivityFullDefinition> findActivityDefinitions(ProcessDefinitionUUID processUUID) {
        return this.getQuerierDbSession().findActivityDefinitions(processUUID);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name, ProcessState state) {
        return this.getQuerierDbSession().findProcessDefinition(name, state);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(ProcessState state) {
        return this.getQuerierDbSession().findProcessDefinition(state);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions(QName name) {
        return this.getQuerierDbSession().findProcessDefinition(name);
    }

    @Override
    public List<ProcessFullDefinition> findProcessDefinitions() {
        return this.getQuerierDbSession().findProcessDefinition();
    }

    @Override
    public ProcessFullDefinition getProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        return this.getQuerierDbSession().getProcessDefinition(processDefinitionUUID);
    }

    @Override
    public ProcessFullDefinition removeProcessDefinition(ProcessDefinitionUUID processDefinitionUUID) {
        ProcessFullDefinition processFullDefinition = this.getProcessDefinition(processDefinitionUUID);
        if (processFullDefinition != null) {
            this.getQuerierDbSession().delete(processFullDefinition);
            return processFullDefinition.fullCopy();
        }
        return null;
    }

    @Override
    public ProcessFullInstance removeProcessInstance(ProcessInstanceUUID processInstanceUUID) {
        ProcessFullInstance processFullInstance = this.getProcessInstance(processInstanceUUID);
        if (processFullInstance != null) {
            this.removeProcessInstance(processFullInstance);
            this.getQuerierDbSession().delete(processFullInstance);
            return (ProcessFullInstance)processFullInstance.fullCopy();
        }
        return null;
    }
}

